/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito;

import org.limewire.mojito.Context;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.settings.ContextSettings;

public class MojitoFactory {
    private static final String DEFAULT_NAME = "DHT";

    private MojitoFactory() {
    }

    public static MojitoDHT createDHT() {
        return MojitoFactory.createDHT(DEFAULT_NAME);
    }

    public static MojitoDHT createDHT(String name) {
        return MojitoFactory.create(name, false);
    }

    public static MojitoDHT createDHT(String name, Vendor vendor, Version version) {
        return MojitoFactory.create(name, vendor, version, false);
    }

    public static MojitoDHT createFirewalledDHT() {
        return MojitoFactory.createFirewalledDHT(DEFAULT_NAME);
    }

    public static MojitoDHT createFirewalledDHT(String name) {
        return MojitoFactory.create(name, true);
    }

    public static MojitoDHT createFirewalledDHT(String name, Vendor vendor, Version version) {
        return MojitoFactory.create(name, vendor, version, true);
    }

    private static Context create(String name, boolean firewalled) {
        return MojitoFactory.create(name, ContextSettings.getVendor(), ContextSettings.getVersion(), firewalled);
    }

    private static Context create(String name, Vendor vendor, Version version, boolean firewalled) {
        if (name == null) {
            name = DEFAULT_NAME;
        }
        return new Context(name, vendor, version, firewalled);
    }
}

