/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.result.StoreResult;

public class Storable {
    private final KUID primaryKey;
    private final DHTValue value;
    private long publishTime;
    private int locationCount;

    public Storable(KUID primaryKey, DHTValue value) {
        this.primaryKey = primaryKey;
        this.value = value;
    }

    public KUID getPrimaryKey() {
        return this.primaryKey;
    }

    public DHTValue getValue() {
        return this.value;
    }

    public synchronized long getPublishTime() {
        return this.publishTime;
    }

    public synchronized void setPublishTime(long publishTime) {
        if (publishTime < 0L) {
            throw new IllegalArgumentException("PublishTime is negative: " + publishTime);
        }
        this.publishTime = publishTime;
    }

    public synchronized int getLocationCount() {
        return this.locationCount;
    }

    public synchronized void setLocationCount(int locationCount) {
        if (locationCount < 0) {
            throw new IllegalArgumentException("LocationCount is negative: " + locationCount);
        }
        this.locationCount = locationCount;
    }

    protected synchronized void handleStoreResult(StoreResult result) {
        this.setPublishTime(System.currentTimeMillis());
        this.setLocationCount(result.getLocations().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder builder = new StringBuilder();
        Storable storable = this;
        synchronized (storable) {
            builder.append("PrimaryKey=").append(this.getPrimaryKey()).append("\n");
            builder.append("Value=").append(this.getValue()).append("\n");
            builder.append("PublishTime=").append(this.getPublishTime()).append("\n");
            builder.append("LocationCount=").append(this.getLocationCount()).append("\n");
        }
        return builder.toString();
    }
}

