/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.io;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.io.MessageDispatcher;
import org.limewire.mojito.io.Tag;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageFormatException;
import org.limewire.mojito.settings.NetworkSettings;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;
import org.limewire.security.Verifier;

public class MessageDispatcherImpl
extends MessageDispatcher
implements Runnable {
    private static final Log LOG = LogFactory.getLog(MessageDispatcherImpl.class);
    private static final long WAIT_ON_LOCK = 5000L;
    private static final int RECEIVE_BUFFER_SIZE = NetworkSettings.RECEIVE_BUFFER_SIZE.getValue();
    private static final int SEND_BUFFER_SIZE = NetworkSettings.SEND_BUFFER_SIZE.getValue();
    private static final long SELECTOR_SLEEP = 50L;
    private volatile boolean running = false;
    private volatile boolean accepting = false;
    private Selector selector;
    private DatagramChannel channel;
    private final Object lock = new Object();
    private Thread thread;
    private final ByteBuffer receiveBuffer;
    private List<Runnable> tasks = new ArrayList<Runnable>();
    private List<Tag> outputQueue = new LinkedList<Tag>();
    private volatile boolean allocateNewByteBuffer = NetworkSettings.ALLOCATE_NEW_BUFFER.getValue();

    public MessageDispatcherImpl(Context context) {
        super(context);
        this.receiveBuffer = ByteBuffer.allocate(RECEIVE_BUFFER_SIZE);
    }

    public void setAllocateNewByteBuffer(boolean allocateNewByteBuffer) {
        this.allocateNewByteBuffer = allocateNewByteBuffer;
    }

    public boolean getAllocateNewByteBuffer() {
        return this.allocateNewByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(SocketAddress address) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isBound()) {
                throw new IOException("DatagramChannel is already bound");
            }
            this.channel = DatagramChannel.open();
            this.channel.configureBlocking(false);
            this.selector = Selector.open();
            this.channel.register(this.selector, 1);
            DatagramSocket socket = this.channel.socket();
            socket.setReuseAddress(false);
            socket.setReceiveBufferSize(RECEIVE_BUFFER_SIZE);
            socket.setSendBufferSize(SEND_BUFFER_SIZE);
            socket.bind(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return this.channel != null && this.channel.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBound() {
        Object object = this.lock;
        synchronized (object) {
            return this.channel != null && this.channel.socket().isBound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannel getDatagramChannel() {
        Object object = this.lock;
        synchronized (object) {
            return this.channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress getLocalSocketAddress() {
        Object object = this.lock;
        synchronized (object) {
            if (this.channel != null && this.channel.isOpen()) {
                return this.channel.socket().getLocalSocketAddress();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isBound()) {
                throw new IllegalStateException("MessageDispatcher is not bound");
            }
            if (!this.running) {
                this.accepting = true;
                this.running = true;
                this.thread = this.context.getDHTExecutorService().getThreadFactory().newThread(this);
                this.thread.setName(this.context.getName() + "-MessageDispatcherThread");
                this.thread.setDaemon(Boolean.getBoolean("com.limegroup.mojito.io.MessageDispatcherIsDaemon"));
                this.thread.start();
                Runnable startup = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = MessageDispatcherImpl.this.lock;
                        synchronized (object) {
                            try {
                                MessageDispatcherImpl.super.start();
                            }
                            finally {
                                MessageDispatcherImpl.this.lock.notifyAll();
                            }
                        }
                    }
                };
                this.process(startup);
                try {
                    this.lock.wait(5000L);
                }
                catch (InterruptedException err) {
                    LOG.error("InterruptedException", err);
                }
            }
        }
    }

    @Override
    protected boolean submit(final Tag tag) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                MessageDispatcherImpl.this.outputQueue.add(tag);
                MessageDispatcherImpl.this.interestWrite(true);
            }
        };
        this.process(task);
        return true;
    }

    private void handleWrite() throws IOException {
        Tag tag = null;
        while (!this.outputQueue.isEmpty()) {
            tag = this.outputQueue.get(0);
            if (tag.isCancelled()) {
                this.outputQueue.remove(0);
                continue;
            }
            try {
                SocketAddress dst = tag.getSocketAddress();
                ByteBuffer data = tag.getData();
                if (!this.send(dst, data)) break;
                this.outputQueue.remove(0);
                this.register(tag);
            }
            catch (IOException err) {
                LOG.error("IOException", err);
                this.outputQueue.remove(0);
                this.handleError(tag, err);
            }
        }
        this.interestWrite(!this.outputQueue.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.accepting = false;
            if (this.isRunning()) {
                Runnable shutdown = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = MessageDispatcherImpl.this.lock;
                        synchronized (object) {
                            try {
                                MessageDispatcherImpl.this.running = false;
                                MessageDispatcherImpl.super.stop();
                            }
                            finally {
                                MessageDispatcherImpl.this.lock.notifyAll();
                            }
                        }
                    }
                };
                this.process(shutdown);
                try {
                    this.lock.wait(5000L);
                }
                catch (InterruptedException err) {
                    LOG.error("InterruptedException", err);
                }
                if (this.thread != null) {
                    this.thread.interrupt();
                    this.thread = null;
                }
                this.tasks.clear();
                this.outputQueue.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        Object object = this.lock;
        synchronized (object) {
            assert (!this.isRunning());
            if (this.selector != null) {
                try {
                    this.selector.close();
                    this.selector = null;
                }
                catch (IOException err) {
                    LOG.error("IOException", err);
                }
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                    this.channel = null;
                }
                catch (IOException err) {
                    LOG.error("IOException", err);
                }
            }
        }
    }

    @Override
    public boolean isAccepting() {
        return this.accepting;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    private void handleRead() throws IOException {
        while (this.isRunning()) {
            DHTMessage message = null;
            try {
                message = this.readMessage();
            }
            catch (MessageFormatException err) {
                LOG.error("Message Format Exception: ", err);
                continue;
            }
            if (message == null) break;
            this.handleMessage(message);
        }
        this.interestRead(true);
    }

    private DHTMessage readMessage() throws MessageFormatException, IOException {
        SocketAddress src = this.receive((ByteBuffer)this.receiveBuffer.clear());
        if (src != null) {
            this.receiveBuffer.flip();
            ByteBuffer data = null;
            if (this.getAllocateNewByteBuffer()) {
                int length = this.receiveBuffer.remaining();
                data = ByteBuffer.allocate(length);
                data.put(this.receiveBuffer);
                data.rewind();
            } else {
                data = this.receiveBuffer.slice();
            }
            DHTMessage message = this.deserialize(src, data);
            return message;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning()) {
                this.tasks.add(runnable);
                this.selector.wakeup();
            }
        }
    }

    @Override
    protected void verify(SecureMessage secureMessage, SecureMessageCallback smc) {
        final PublicKey pubKey = this.context.getPublicKey();
        if (pubKey == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Dropping SecureMessage " + secureMessage + " because PublicKey is not set");
            }
            return;
        }
        Verifier verifier = new Verifier(secureMessage, smc){

            @Override
            public String getAlgorithm() {
                return "SHA1withDSA";
            }

            @Override
            public PublicKey getPublicKey() {
                return pubKey;
            }
        };
        this.verify(verifier);
    }

    protected void verify(Runnable verifier) {
        this.process(verifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interest(int ops, boolean on) {
        block7: {
            try {
                SelectionKey sk = this.channel.keyFor(this.selector);
                if (sk == null || !sk.isValid()) break block7;
                Object object = this.channel.blockingLock();
                synchronized (object) {
                    if (on) {
                        sk.interestOps(sk.interestOps() | ops);
                    } else {
                        sk.interestOps(sk.interestOps() & ~ops);
                    }
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
    }

    private void interestRead(boolean on) {
        this.interest(1, on);
    }

    private void interestWrite(boolean on) {
        this.interest(4, on);
    }

    private SocketAddress receive(ByteBuffer dst) throws IOException {
        return this.channel.receive(dst);
    }

    private boolean send(SocketAddress dst, ByteBuffer data) throws IOException {
        return this.channel.send(data, dst) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAll() {
        List<Runnable> process = null;
        Object object = this.lock;
        synchronized (object) {
            process = this.tasks;
            this.tasks = new ArrayList<Runnable>();
        }
        for (Runnable task : process) {
            task.run();
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.processAll();
                if (!this.isRunning() || !this.isOpen()) break;
                this.selector.select(50L);
                try {
                    this.handleRead();
                }
                catch (IOException err) {
                    LOG.error("IOException-READ", err);
                }
                try {
                    this.handleWrite();
                }
                catch (IOException err) {
                    LOG.error("IOException-WRITE", err);
                }
            }
        }
        catch (IOException err) {
            Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), err);
        }
    }
}

