/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.limewire.nio.BufferOutputStream;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.observer.WriteObserver;

class NIOOutputStream
implements WriteObserver {
    private final Shutdownable handler;
    private final InterestWritableByteChannel channel;
    private BufferOutputStream sink;
    private volatile Object bufferLock;
    private ByteBuffer buffer;
    private boolean shutdown;

    NIOOutputStream(Shutdownable handler, InterestWritableByteChannel channel) {
        this.handler = handler;
        this.channel = channel;
    }

    private synchronized NIOOutputStream init() throws IOException {
        if (this.buffer != null) {
            throw new IllegalStateException("already init'd!");
        }
        if (this.shutdown) {
            throw new IOException("already closed!");
        }
        this.buffer = NIODispatcher.instance().getBufferCache().getHeap();
        this.sink = new BufferOutputStream(this.buffer, this.handler, this, this.channel);
        this.bufferLock = this.sink.getBufferLock();
        return this;
    }

    synchronized OutputStream getOutputStream() throws IOException {
        if (this.buffer == null) {
            this.init();
        }
        return this.sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleWrite() throws IOException {
        if (this.buffer == null) {
            return false;
        }
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.flip();
            while (this.buffer.hasRemaining() && this.channel.write(this.buffer) > 0) {
            }
            if (this.buffer.position() > 0) {
                if (this.buffer.hasRemaining()) {
                    this.buffer.compact();
                } else {
                    this.buffer.clear();
                }
            } else {
                this.buffer.position(this.buffer.limit()).limit(this.buffer.capacity());
            }
            if (this.buffer.hasRemaining()) {
                this.bufferLock.notify();
            }
            if (this.buffer.position() == 0) {
                this.channel.interestWrite(this, false);
                return false;
            }
            return true;
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.sink != null) {
            this.sink.shutdown();
        }
        if (this.buffer != null) {
            NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    NIODispatcher.instance().getBufferCache().release(NIOOutputStream.this.buffer);
                }
            });
        }
    }

    @Override
    public void handleIOException(IOException iox) {
        throw new RuntimeException("unsupported operation", iox);
    }
}

