/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.timeout;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Periodic;
import org.limewire.nio.observer.Shutdownable;

public final class StalledUploadWatchdog
extends Periodic {
    private static final Log LOG = LogFactory.getLog(StalledUploadWatchdog.class);
    public static long DELAY_TIME = 120000L;
    private final Closer closer = (Closer)this.getRunnable();
    private final long delayTime;

    public StalledUploadWatchdog(long delayTime, ScheduledExecutorService service) {
        super(new Closer(), service);
        this.delayTime = delayTime;
    }

    public boolean deactivate() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deactivated on " + this.closer.shutdownable);
        }
        this.unschedule();
        this.closer.shutdownable = null;
        return this.closer.closed;
    }

    public synchronized void activate(Shutdownable shutdownable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Activated on: " + shutdownable);
        }
        this.rescheduleIfLater(this.delayTime);
        this.closer.shutdownable = shutdownable;
    }

    private static class Closer
    implements Runnable {
        private volatile Shutdownable shutdownable;
        private volatile boolean closed;

        private Closer() {
        }

        @Override
        public void run() {
            this.closed = true;
            Shutdownable toShut = this.shutdownable;
            if (toShut != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("STALLED!  Killing: " + toShut);
                }
                toShut.shutdown();
                this.shutdownable = null;
            }
        }
    }
}

