/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion.containers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.GGEP;
import org.limewire.promotion.containers.BucketMessageContainer;
import org.limewire.promotion.containers.MessageContainer;
import org.limewire.promotion.containers.MultiMessageContainer;
import org.limewire.promotion.containers.PromotionMessageContainer;
import org.limewire.promotion.containers.SignedMessageContainer;

public class MessageContainerParser {
    private static Set<MessageContainer> parsers = new HashSet<MessageContainer>();

    public static void addParser(MessageContainer containerType) {
        parsers.add(containerType);
    }

    public MessageContainer parse(GGEP ggepMessage) throws BadGGEPBlockException {
        byte[] type = ggepMessage.get("T");
        for (MessageContainer container : parsers) {
            if (!Arrays.equals(container.getType(), type)) continue;
            try {
                MessageContainer instance = (MessageContainer)container.getClass().newInstance();
                instance.decode(ggepMessage);
                return instance;
            }
            catch (InstantiationException ex) {
                throw new BadGGEPBlockException("InstantiationException caught." + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                throw new BadGGEPBlockException("IllegalAccessException caught." + ex.getMessage());
            }
        }
        throw new BadGGEPBlockException("No parsers understood passed in type.");
    }

    public MessageContainer parse(byte[] rawMessage) throws BadGGEPBlockException {
        return this.parse(new GGEP(rawMessage, 0));
    }

    static {
        MessageContainerParser.addParser(new SignedMessageContainer());
        MessageContainerParser.addParser(new MultiMessageContainer());
        MessageContainerParser.addParser(new PromotionMessageContainer());
        MessageContainerParser.addParser(new BucketMessageContainer());
    }
}

