/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion.containers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.GGEP;
import org.limewire.io.IOUtils;
import org.limewire.promotion.containers.MapMessageContainer;
import org.limewire.promotion.containers.MessageContainer;
import org.limewire.promotion.containers.MessageContainerParser;
import org.limewire.util.StringUtils;

public class MultiMessageContainer
extends MapMessageContainer {
    private static final String KEY_WRAPPED_BYTES = "W";
    private final List<MessageContainer> list = new ArrayList<MessageContainer>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Object parsingLock = new Object();

    @Override
    public byte[] getType() {
        return StringUtils.toUTF8Bytes("MULT");
    }

    @Override
    public void decode(GGEP rawGGEP) throws BadGGEPBlockException {
        if (!rawGGEP.hasValueFor(KEY_WRAPPED_BYTES)) {
            throw new BadGGEPBlockException("Missing wrappedBytes");
        }
        super.decode(rawGGEP);
    }

    private byte[] getWrappedBytes() {
        byte[] bytes = this.getBytes(KEY_WRAPPED_BYTES);
        try {
            if (bytes != null) {
                return IOUtils.inflate(bytes);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageContainer> getWrappedMessages() {
        Object object = this.parsingLock;
        synchronized (object) {
            byte[] bytes;
            if (!this.initialized.getAndSet(true) && (bytes = this.getWrappedBytes()).length > 0) {
                int[] nextOffset = new int[1];
                int offset = 0;
                MessageContainerParser parser = new MessageContainerParser();
                while (offset < bytes.length) {
                    try {
                        this.list.add(parser.parse(new GGEP(bytes, offset, nextOffset)));
                        offset = nextOffset[0];
                    }
                    catch (BadGGEPBlockException ex) {
                        throw new RuntimeException("Parsing error: ", ex);
                    }
                }
            }
        }
        return this.list;
    }

    public void setWrappedMessages(List<MessageContainer> messages) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (MessageContainer message : messages) {
            try {
                out.write(message.encode());
            }
            catch (IOException ex) {
                throw new RuntimeException("IOException? WTF?", ex);
            }
        }
        this.put(KEY_WRAPPED_BYTES, IOUtils.deflate(out.toByteArray()));
    }
}

