/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.io.File;
import java.util.Properties;
import org.limewire.setting.AbstractSetting;

public class FileSetting
extends AbstractSetting<File> {
    private String absolutePath;

    FileSetting(Properties defaultProps, Properties props, String key, File defaultFile) {
        super(defaultProps, props, key, defaultFile.getAbsolutePath());
        this.setPrivate(true);
    }

    @Override
    public File get() {
        return new File(this.absolutePath);
    }

    @Override
    public void set(File value) {
        this.setValueInternal(value.getAbsolutePath());
    }

    @Override
    protected void loadValue(String sValue) {
        File value = new File(sValue);
        this.absolutePath = value.getAbsolutePath();
    }

    @Override
    public FileSetting setAlwaysSave(boolean on) {
        super.setAlwaysSave(on);
        return this;
    }

    public FileSetting createParentDirs() {
        File parent;
        String parentString;
        File value = this.get();
        if (value != null && (parentString = value.getParent()) != null && !(parent = new File(parentString)).isDirectory()) {
            parent.mkdirs();
        }
        return this;
    }
}

