/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing;

import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.google.inject.Inject;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import javax.swing.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.limewire.core.api.download.DownloadAction;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.lifecycle.LifeCycleManager;
import org.limewire.ui.swing.mainframe.AboutAction;
import org.limewire.ui.swing.mainframe.OptionsAction;
import org.limewire.ui.swing.menu.ExitAction;
import org.limewire.ui.swing.util.NativeLaunchUtils;
import org.limewire.util.OSUtils;

public class MacEventHandler
extends ApplicationAdapter {
    private static MacEventHandler INSTANCE;
    private volatile File lastFileOpened = null;
    private volatile boolean enabled;
    @Inject
    private volatile ExternalControl externalControl = null;
    @Inject
    private volatile DownloadManager downloadManager = null;
    @Inject
    private volatile LifeCycleManager lifecycleManager = null;
    @Inject
    private volatile ActivityCallback activityCallback = null;
    @Inject
    private volatile AboutAction aboutAction = null;
    @Inject
    private volatile OptionsAction optionsAction = null;
    @Inject
    private volatile ExitAction exitAction = null;
    @Inject
    private volatile CategoryManager categoryManager = null;
    private boolean allMenusAndActionsEnabled = false;

    public static synchronized MacEventHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new MacEventHandler();
        }
        return INSTANCE;
    }

    @Inject
    public MacEventHandler() {
        assert (OSUtils.isMacOSX()) : "MacEventHandler should only be used on Mac OS-X operating systems.";
        com.apple.eawt.Application.getApplication().addApplicationListener((ApplicationListener)this);
        com.apple.eawt.Application.getApplication().setEnabledPreferencesMenu(false);
        com.apple.eawt.Application.getApplication().setEnabledAboutMenu(false);
    }

    @Inject
    public void startup() {
        this.enabled = true;
        if (this.lastFileOpened != null) {
            this.runFileOpen(this.lastFileOpened);
        }
    }

    public void enableAllMacMenusAndEventHandlers() {
        com.apple.eawt.Application.getApplication().setEnabledAboutMenu(true);
        com.apple.eawt.Application.getApplication().setEnabledPreferencesMenu(true);
        this.allMenusAndActionsEnabled = true;
    }

    public void handlePreferences(ApplicationEvent event) {
        if (this.allMenusAndActionsEnabled) {
            this.optionsAction.actionPerformed(null);
            event.setHandled(true);
        }
    }

    public void handleAbout(ApplicationEvent event) {
        if (this.allMenusAndActionsEnabled) {
            this.aboutAction.actionPerformed(null);
            event.setHandled(true);
        }
    }

    public void handleQuit(ApplicationEvent event) {
        if (this.allMenusAndActionsEnabled) {
            this.exitAction.actionPerformed(null);
            event.setHandled(true);
        }
    }

    public void handleReOpenApplication(ApplicationEvent event) {
        if (this.allMenusAndActionsEnabled) {
            ApplicationActionMap map = Application.getInstance().getContext().getActionManager().getActionMap();
            Action action = map.get("restoreView");
            if (action != null) {
                action.actionPerformed(null);
            }
            event.setHandled(true);
        }
    }

    public void handleOpenFile(ApplicationEvent event) {
        File file = new File(event.getFilename());
        if (!this.enabled) {
            this.lastFileOpened = file;
        } else {
            this.runFileOpen(file);
        }
        event.setHandled(true);
    }

    private void runFileOpen(final File file) {
        String filename = file.getPath();
        if (filename.endsWith("limestart")) {
            LimeWireUtils.setAutoStartupLaunch(true);
        } else if (filename.endsWith("torrent")) {
            if (!this.lifecycleManager.isStarted()) {
                this.externalControl.enqueueControlRequest(file.getAbsolutePath());
            } else {
                try {
                    this.downloadManager.downloadTorrent(file, null, false);
                }
                catch (DownloadException e) {
                    this.activityCallback.handleDownloadException(new DownloadAction(){

                        @Override
                        public void download(File saveDirectory, boolean overwrite) throws DownloadException {
                            MacEventHandler.this.downloadManager.downloadTorrent(file, saveDirectory, overwrite);
                        }

                        @Override
                        public void downloadCanceled(DownloadException ignored) {
                        }
                    }, e, false);
                }
            }
        } else {
            NativeLaunchUtils.safeLaunchFile(file, this.categoryManager);
        }
    }
}

