/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.advanced.connection;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupManager {
    private static final int POPUP_DURATION = 4000;
    private final PopupProvider popupProvider;
    private JPopupMenu popup;
    private Timer exitTimer;

    public PopupManager(PopupProvider popupProvider) {
        this.popupProvider = popupProvider;
    }

    public void showTimedPopup(Component owner, int x, int y) {
        Component content = this.popupProvider.getPopupContent();
        if (this.popup == null && content != null) {
            content.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    PopupManager.this.hidePopup();
                }
            });
            this.popup = this.createPopup(content);
            this.popup.show(owner, x, y);
            this.startExitTimer();
        }
    }

    public void hidePopup() {
        if (this.popup != null) {
            this.popup.setVisible(false);
            this.popup = null;
        }
        this.stopExitTimer();
    }

    private JPopupMenu createPopup(Component component) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(BorderFactory.createEmptyBorder());
        popupMenu.setFocusable(false);
        popupMenu.add(component);
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                PopupManager.this.popup = null;
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        return popupMenu;
    }

    private void startExitTimer() {
        this.stopExitTimer();
        this.exitTimer = new Timer(4000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupManager.this.hidePopup();
            }
        });
        this.exitTimer.start();
    }

    private void stopExitTimer() {
        if (this.exitTimer != null) {
            this.exitTimer.stop();
            this.exitTimer = null;
        }
    }

    public static interface PopupProvider {
        public Component getPopupContent();
    }
}

