/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.browser;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.URI;
import java.net.URISyntaxException;
import org.limewire.concurrent.ManagedThread;
import org.limewire.core.api.magnet.MagnetFactory;
import org.limewire.core.api.magnet.MagnetLink;
import org.limewire.ui.swing.browser.LimeDomListener;
import org.limewire.ui.swing.browser.UriAction;
import org.limewire.ui.swing.util.MagnetHandler;
import org.limewire.ui.swing.util.NativeLaunchUtils;
import org.limewire.util.URIUtils;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMWindow2;
import org.mozilla.interfaces.nsIWebBrowserChrome;
import org.w3c.dom.Node;

public class BrowserUtils {
    private static final LimeDomListener DOM_ADAPTER = new LimeDomListener();

    @Inject
    public static void registerBlankTarget() {
        BrowserUtils.addTargetedUrlAction("_blank", new UriAction(){

            @Override
            public boolean uriClicked(final UriAction.TargetedUri targetedUrl) {
                new ManagedThread(new Runnable(){

                    @Override
                    public void run() {
                        NativeLaunchUtils.openURL(targetedUrl.getUri());
                    }
                }).start();
                return true;
            }
        });
    }

    @Inject
    public static void registerMagnetProtocol(final MagnetFactory magnetFactory, final Provider<MagnetHandler> magnetHandler) {
        BrowserUtils.addProcotolHandlerAction("magnet", new UriAction(){

            @Override
            public boolean uriClicked(UriAction.TargetedUri targetedUrl) {
                try {
                    MagnetLink[] magnetLinks;
                    URI uri = URIUtils.toURI(targetedUrl.getUri());
                    for (MagnetLink magnetLink : magnetLinks = magnetFactory.parseMagnetLink(uri)) {
                        ((MagnetHandler)magnetHandler.get()).handleMagnet(magnetLink);
                    }
                }
                catch (URISyntaxException e) {
                    return false;
                }
                return true;
            }
        });
    }

    @Inject
    public static void registerMailToProtocol(MagnetFactory magnetFactory) {
        BrowserUtils.addProcotolHandlerAction("mailto", new UriAction(){

            @Override
            public boolean uriClicked(final UriAction.TargetedUri targetedUrl) {
                new ManagedThread(new Runnable(){

                    @Override
                    public void run() {
                        NativeLaunchUtils.openURL(targetedUrl.getUri());
                    }
                }).start();
                return true;
            }
        });
    }

    public static void addTargetedUrlAction(String target, UriAction action) {
        DOM_ADAPTER.addTargetedUrlAction(target, action);
    }

    public static void addProcotolHandlerAction(String protocol, UriAction action) {
        DOM_ADAPTER.addProtocolHandlerAction(protocol, action);
    }

    static boolean isTextControl(Node node) {
        Node type;
        boolean isText = false;
        isText = "input".equalsIgnoreCase(node.getNodeName()) ? (type = node.getAttributes().getNamedItem("type")) == null || "text".equalsIgnoreCase(type.getNodeValue()) || "password".equalsIgnoreCase(type.getNodeValue()) : "textarea".equalsIgnoreCase(node.getNodeName());
        return isText;
    }

    static void addDomListener(nsIWebBrowserChrome chrome) {
        nsIDOMEventTarget eventTarget = XPCOMUtils.qi(chrome.getWebBrowser().getContentDOMWindow(), nsIDOMWindow2.class).getWindowRoot();
        eventTarget.addEventListener("click", DOM_ADAPTER, true);
        eventTarget.addEventListener("submit", DOM_ADAPTER, true);
    }

    static void removeDomListener(nsIWebBrowserChrome chrome) {
        nsIDOMEventTarget eventTarget = XPCOMUtils.qi(chrome.getWebBrowser().getContentDOMWindow(), nsIDOMWindow2.class).getWindowRoot();
        eventTarget.removeEventListener("click", DOM_ADAPTER, true);
        eventTarget.removeEventListener("submit", DOM_ADAPTER, true);
    }
}

