/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BoxPanel
extends JPanel {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final Dimension HORIZONTAL_COMPONENT_GAP = new Dimension(6, 0);
    public static final Dimension VERTICAL_COMPONENT_GAP = new Dimension(0, 6);
    public static final Dimension LINE_GAP = new Dimension(0, 10);

    public BoxPanel() {
        this.setLayout(new BoxLayout(this, 1));
    }

    public BoxPanel(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("Illegal BoxPanel orientation");
        }
        this.setLayout(new BoxLayout(this, orientation));
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("Illegal BoxPanel orientation");
        }
        this.setLayout(new BoxLayout(this, orientation));
    }

    public void addLineGap() {
        this.add(Box.createRigidArea(LINE_GAP));
    }

    public void addHorizontalComponentGap() {
        this.add(Box.createRigidArea(HORIZONTAL_COMPONENT_GAP));
    }

    public void addVerticalComponentGap() {
        this.add(Box.createRigidArea(VERTICAL_COMPONENT_GAP));
    }

    public void addLeft(JComponent component) {
        component.setAlignmentX(1.0f);
        super.add(component);
    }

    public void addCenter(JComponent component) {
        component.setAlignmentX(0.5f);
        super.add(component);
    }

    public void addRight(JComponent component) {
        component.setAlignmentX(0.0f);
        super.add(component);
    }
}

