/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.util.Collection;
import javax.swing.MutableComboBoxModel;
import org.limewire.ui.swing.components.CollectionBackedListModel;

public class CollectionBackedComboBoxModel
extends CollectionBackedListModel
implements MutableComboBoxModel {
    private Object selectedObject;

    public CollectionBackedComboBoxModel(Collection<?> data) {
        super(data);
        if (this.getSize() > 0) {
            this.setSelectedItem(this.getElementAt(0));
        }
    }

    public void addElement(Object obj) {
        this.data.add(obj);
        this.fireIntervalAdded(this, this.data.size() - 1, this.data.size() - 1);
        if (this.data.size() == 1 && this.selectedObject == null && obj != null) {
            this.setSelectedItem(obj);
        }
    }

    public void insertElementAt(Object obj, int index) {
        this.data.add(index, obj);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void removeElement(Object obj) {
        int index = this.data.indexOf(obj);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    @Override
    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedObject) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.data.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (this.selectedObject != null && !this.selectedObject.equals(anItem) || this.selectedObject == null && anItem != null) {
            this.selectedObject = anItem;
            this.fireContentsChanged(this, -1, -1);
        }
    }
}

