/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.util.GuiUtils;

public class HTMLLabel
extends JEditorPane {
    public static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private StyleSheet fontStyle = null;
    private StyleSheet colorStyle = null;
    private StyleSheet linkStyle = null;
    private final StyleSheet mainStyle;
    private Font htmlFont = null;
    private Color htmlFontColor;
    @Resource
    private Color linkColor = Color.BLUE;
    private HyperlinkListener openInNativeBrowserListener = GuiUtils.getHyperlinkListener();

    public HTMLLabel(String htmlText) {
        super("text/html", htmlText);
        GuiUtils.assignResources(this);
        this.setEditable(false);
        this.setCaretPosition(0);
        this.mainStyle = ((HTMLDocument)this.getDocument()).getStyleSheet();
        this.setSelectionColor(TRANSPARENT_COLOR);
        this.setHtmlLinkForeground(this.linkColor);
        this.addHyperlinkListener(this.openInNativeBrowserListener);
        JLabel label = new JLabel();
        this.setBackground(label.getBackground());
        this.setHtmlFont(label.getFont());
    }

    public HTMLLabel() {
        this((String)null);
    }

    public void setOpenUrlsNatively(boolean enable) {
        if (enable) {
            if (this.openInNativeBrowserListener == null) {
                this.openInNativeBrowserListener = GuiUtils.getHyperlinkListener();
                this.addHyperlinkListener(this.openInNativeBrowserListener);
            }
        } else if (this.openInNativeBrowserListener != null) {
            this.removeHyperlinkListener(this.openInNativeBrowserListener);
            this.openInNativeBrowserListener = null;
        }
    }

    public Font getHtmlFont() {
        return this.htmlFont;
    }

    public void setHtmlFont(Font font) {
        this.htmlFont = font;
        if (this.fontStyle != null) {
            this.mainStyle.removeStyleSheet(this.fontStyle);
        }
        this.fontStyle = new StyleSheet();
        this.fontStyle.addRule(this.createCSS(font));
        this.mainStyle.addStyleSheet(this.fontStyle);
    }

    public void setHtmlForeground(Color color) {
        this.htmlFontColor = color;
        if (this.colorStyle != null) {
            this.mainStyle.removeStyleSheet(this.colorStyle);
        }
        this.colorStyle = new StyleSheet();
        this.colorStyle.addRule(this.createCSS(color));
        this.mainStyle.addStyleSheet(this.colorStyle);
    }

    private String createCSS(Color color) {
        StringBuilder builder = new StringBuilder("body {");
        builder.append("color: ").append(GuiUtils.colorToHex(color)).append(";");
        builder.append("}");
        return builder.toString();
    }

    public Color getHtmlForeground() {
        return this.htmlFontColor;
    }

    public void setHtmlLinkForeground(Color color) {
        this.linkColor = color;
        if (this.linkStyle != null) {
            this.mainStyle.removeStyleSheet(this.linkStyle);
        }
        this.linkStyle = new StyleSheet();
        this.linkStyle.addRule(this.createLinkCSS(color));
        this.mainStyle.addStyleSheet(this.linkStyle);
    }

    private String createLinkCSS(Color color) {
        StringBuilder builder = new StringBuilder("body a {");
        builder.append("color: ").append(GuiUtils.colorToHex(color)).append(";");
        builder.append("}");
        return builder.toString();
    }

    private String createCSS(Font font) {
        StringBuilder builder = new StringBuilder("body {");
        builder.append("font-family: ").append(font.getFamily()).append(";");
        builder.append("font-size: ").append(font.getSize()).append("pt;");
        if (font.isItalic()) {
            builder.append("font-style: italic;");
        }
        if (font.isBold()) {
            builder.append("font-weight: bold;");
        }
        builder.append("}");
        return builder.toString();
    }
}

