/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class Line
extends JComponent {
    private boolean horizontal;
    private Color color;

    public static Line createHorizontalLine(Color color, int thickness) {
        return new Line(true, color, thickness);
    }

    public static Line createHorizontalLine(Color color) {
        return new Line(true, color, 1);
    }

    public static Line createHorizontalLine() {
        return new Line(true, Color.BLACK, 1);
    }

    public static Line createVerticalLine(Color color, int thickness) {
        return new Line(false, color, thickness);
    }

    public static Line createVerticalLine(Color color) {
        return new Line(false, color, 1);
    }

    public static Line createVerticalLine() {
        return new Line(false, Color.BLACK, 1);
    }

    private Line(boolean horizontal, Color color, int thickness) {
        if (color == null) {
            throw new IllegalArgumentException("color must not be null");
        }
        this.horizontal = horizontal;
        this.color = color;
        this.initSize(horizontal, thickness);
    }

    private void initSize(boolean horizontal, int thickness) {
        if (horizontal) {
            this.setPreferredSize(new Dimension(1, thickness));
            this.setMinimumSize(new Dimension(0, thickness));
            this.setMaximumSize(new Dimension(Short.MAX_VALUE, thickness));
        } else {
            this.setPreferredSize(new Dimension(thickness, 1));
            this.setMinimumSize(new Dimension(thickness, 0));
            this.setMaximumSize(new Dimension(thickness, Short.MAX_VALUE));
        }
    }

    public void setThickness(int thickness) {
        this.initSize(this.horizontal, thickness);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        g.setColor(this.color);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(oldColor);
    }
}

