/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.Painter;
import org.limewire.ui.swing.components.HTMLLabel;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.util.GuiUtils;

public class MessageComponent
extends JPanel {
    @Resource
    private Font headingFont;
    @Resource
    private Color fontColor;
    @Resource
    private Font subFont;
    private final JXPanel messageContainer;
    private final JLabel arrowLabel;

    public MessageComponent() {
        this(18, 22, 22, 18);
    }

    public MessageComponent(int topInset, int leftInset, int bottomInset, int rightInset) {
        super(new MigLayout("insets 0 0 0 0, gap 0"));
        GuiUtils.assignResources(this);
        this.setOpaque(false);
        this.messageContainer = new JXPanel(new MigLayout("insets " + topInset + " " + leftInset + " " + bottomInset + " " + rightInset + ", hidemode 3"));
        this.messageContainer.setOpaque(false);
        this.arrowLabel = new JLabel();
        this.add((Component)this.arrowLabel, "pos (messageContainer.x + 25) 0.99al");
        this.add((Component)this.messageContainer, "wrap");
    }

    public void setMessageBackroundPainter(Painter painter) {
        this.messageContainer.setBackgroundPainter(painter);
    }

    public void setArrowIcon(Icon icon) {
        this.arrowLabel.setIcon(icon);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, icon.getIconHeight() - 2, 0));
    }

    public void addComponent(JComponent component, String layout) {
        this.messageContainer.add((Component)component, layout);
    }

    public void decorateHeaderLabel(JComponent component) {
        component.setFont(this.headingFont);
        component.setForeground(this.fontColor);
    }

    public void decorateHeaderLink(HyperlinkButton link) {
        link.setFont(this.headingFont);
    }

    public void decorateSubLabel(JLabel component) {
        component.setFont(this.subFont);
        component.setForeground(this.fontColor);
    }

    public void decorateSubLabel(HTMLLabel label) {
        label.setHtmlFont(this.subFont);
        label.setHtmlForeground(this.fontColor);
    }

    public void decorateFont(JComponent component) {
        component.setFont(this.subFont);
    }
}

