/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.limewire.collection.MultiIterable;
import org.limewire.core.api.endpoint.RemoteHost;
import org.limewire.ui.swing.components.LimeComboBox;
import org.limewire.ui.swing.components.decorators.ComboBoxDecorator;
import org.limewire.ui.swing.search.BlockUserMenuFactory;
import org.limewire.ui.swing.search.FriendPresenceActions;
import org.limewire.ui.swing.util.I18n;

public class RemoteHostWidget
extends JPanel {
    private final LimeComboBox comboBox;
    private final JPopupMenu comboBoxMenu;
    private final Provider<FriendPresenceActions> fromActions;
    private final Provider<BlockUserMenuFactory> blockUserMenuFactory;
    private List<RemoteHost> people = new ArrayList<RemoteHost>();
    private List<RemoteHost> poppedUpPeople = Collections.emptyList();
    private final RemoteWidgetType type;
    private FriendPresenceActions remoteHostActions;
    private static final String SINGULAR_ACTION_NAME = "singularActionName";

    @Inject
    RemoteHostWidget(ComboBoxDecorator comboBoxDecorator, Provider<FriendPresenceActions> fromActions, Provider<BlockUserMenuFactory> blockUserMenuFactory, @Assisted RemoteWidgetType type) {
        this.fromActions = fromActions;
        this.blockUserMenuFactory = blockUserMenuFactory;
        this.type = type;
        this.comboBox = new LimeComboBox();
        comboBoxDecorator.decorateMiniComboBox(this.comboBox);
        this.comboBoxMenu = new JPopupMenu();
        this.comboBox.overrideMenu(this.comboBoxMenu);
        this.comboBoxMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                if (!((Object)RemoteHostWidget.this.poppedUpPeople).equals(RemoteHostWidget.this.people)) {
                    RemoteHostWidget.this.comboBox.setClickForcesVisible(true);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!((Object)RemoteHostWidget.this.poppedUpPeople).equals(RemoteHostWidget.this.people)) {
                    RemoteHostWidget.this.comboBox.setClickForcesVisible(true);
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                RemoteHostWidget.this.comboBox.setClickForcesVisible(false);
                RemoteHostWidget.this.poppedUpPeople = RemoteHostWidget.this.people;
                RemoteHostWidget.this.updateMenus();
            }
        });
        this.layoutComponents();
        this.setOpaque(false);
    }

    private Action getChatAction(final RemoteHost person) {
        return new AbstractAction(I18n.tr("Chat")){
            {
                super(x0);
                this.putValue(RemoteHostWidget.SINGULAR_ACTION_NAME, I18n.tr("Chat with {0}", person.getFriendPresence().getFriend().getRenderName()));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteHostWidget.this.getRemoteHostAction().chatWith(person.getFriendPresence().getFriend());
            }
        };
    }

    private Action getLibraryAction(final RemoteHost person) {
        return new AbstractAction(I18n.tr("Browse Files")){
            {
                super(x0);
                this.putValue(RemoteHostWidget.SINGULAR_ACTION_NAME, I18n.tr("Browse Files of {0}", person.getFriendPresence().getFriend().getRenderName()));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteHostWidget.this.getRemoteHostAction().viewLibrariesOf(Collections.singleton(person.getFriendPresence()));
            }
        };
    }

    private Action getBlockUserAction(RemoteHost person) {
        Action blockAction = this.blockUserMenuFactory.get().createBlockUserAction(I18n.tr("Block User"), person.getFriendPresence().getFriend());
        blockAction.putValue(SINGULAR_ACTION_NAME, I18n.tr("Block User {0}", person.getFriendPresence().getFriend().getRenderName()));
        return blockAction;
    }

    private FriendPresenceActions getRemoteHostAction() {
        if (this.remoteHostActions == null) {
            this.remoteHostActions = this.fromActions.get();
        }
        return this.remoteHostActions;
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)this.comboBox, "West");
    }

    public void setPerson(RemoteHost remoteHost) {
        this.people.clear();
        this.people.add(remoteHost);
        this.comboBox.setText(this.getFromText());
    }

    public void setPeople(Collection<RemoteHost> people) {
        this.people.clear();
        this.people.addAll(people);
        this.comboBox.setText(this.getFromText());
    }

    private String getFromText() {
        if (this.people.size() == 0) {
            return I18n.tr("nobody");
        }
        if (this.people.size() == 1 && this.type == RemoteWidgetType.UPLOAD) {
            return this.people.get(0).getFriendPresence().getFriend().getRenderName();
        }
        boolean foundFriend = false;
        boolean foundAnon = false;
        for (RemoteHost host : this.people) {
            if (host.getFriendPresence().getFriend().isAnonymous()) {
                foundAnon = true;
            } else {
                foundFriend = true;
            }
            if (!foundAnon || !foundFriend) continue;
            break;
        }
        if (foundFriend && foundAnon) {
            if (this.type == RemoteWidgetType.TABLE) {
                return I18n.trn("{0} Person", "{0} People", this.people.size());
            }
            return I18n.trn("Person", "People", this.people.size());
        }
        if (foundFriend) {
            if (this.type == RemoteWidgetType.TABLE) {
                return this.people.size() == 1 ? this.people.get(0).getFriendPresence().getFriend().getRenderName() : I18n.tr("{0} Friends", this.people.size());
            }
            return this.people.size() == 1 ? this.people.get(0).getFriendPresence().getFriend().getRenderName() : I18n.tr("Friends");
        }
        if (this.type == RemoteWidgetType.TABLE) {
            return I18n.trn("{0} P2P User", "{0} P2P Users", this.people.size());
        }
        return I18n.trn("P2P User", "P2P Users", this.people.size());
    }

    private JMenuItem createItem(Action a) {
        JMenuItem item = new JMenuItem(a);
        this.comboBox.decorateMenuComponent(item);
        return item;
    }

    private void updateMenus() {
        block21: {
            ArrayList<JMenuItem> p2pUsersDisabled;
            ArrayList<JMenuItem> p2pUsers;
            block24: {
                ArrayList<JMenuItem> friendsDisabled;
                ArrayList<JMenuItem> friends;
                block23: {
                    block22: {
                        block20: {
                            this.comboBoxMenu.removeAll();
                            if (this.people.size() == 0) {
                                return;
                            }
                            if (this.people.size() != 1 || this.type != RemoteWidgetType.UPLOAD) break block20;
                            RemoteHost person = this.people.get(0);
                            if (person.isChatEnabled()) {
                                this.comboBoxMenu.add(this.createItem(this.getChatAction(person)));
                            }
                            JMenuItem item = this.createItem(this.getLibraryAction(person));
                            item.setEnabled(person.isBrowseHostEnabled());
                            this.comboBoxMenu.add(item);
                            break block21;
                        }
                        friends = new ArrayList<JMenuItem>();
                        friendsDisabled = new ArrayList<JMenuItem>();
                        p2pUsers = new ArrayList<JMenuItem>();
                        p2pUsersDisabled = new ArrayList<JMenuItem>();
                        ArrayList<RemoteHost> browsableHosts = new ArrayList<RemoteHost>();
                        for (RemoteHost person : this.people) {
                            JMenu submenu = new JMenu(person.getFriendPresence().getFriend().getRenderName());
                            this.comboBox.decorateMenuComponent(submenu);
                            if (person.isChatEnabled()) {
                                submenu.add(this.createItem(this.getChatAction(person)));
                            }
                            if (person.isBrowseHostEnabled()) {
                                submenu.add(this.createItem(this.getLibraryAction(person)));
                            }
                            if (person.getFriendPresence().getFriend().isAnonymous()) {
                                submenu.add(this.createItem(this.getBlockUserAction(person)));
                            }
                            JMenuItem itemToAdd = submenu;
                            if (submenu.getMenuComponentCount() == 1) {
                                itemToAdd = (JMenuItem)submenu.getMenuComponent(0);
                                Action action = itemToAdd.getAction();
                                action.putValue("Name", action.getValue(SINGULAR_ACTION_NAME));
                            } else if (submenu.getMenuComponentCount() == 0) {
                                itemToAdd = new JMenuItem(submenu.getText());
                                this.comboBox.decorateMenuComponent(itemToAdd);
                                itemToAdd.setEnabled(false);
                            }
                            if (itemToAdd.isEnabled()) {
                                browsableHosts.add(person);
                            }
                            if (person.getFriendPresence().getFriend().isAnonymous()) {
                                if (itemToAdd.isEnabled()) {
                                    p2pUsers.add(itemToAdd);
                                    continue;
                                }
                                p2pUsersDisabled.add(itemToAdd);
                                continue;
                            }
                            if (itemToAdd.isEnabled()) {
                                friends.add(itemToAdd);
                                continue;
                            }
                            friendsDisabled.add(itemToAdd);
                        }
                        if (friends.size() + friendsDisabled.size() <= 0 || p2pUsers.size() + p2pUsersDisabled.size() <= 0) break block22;
                        for (JMenuItem friend : new MultiIterable(friends, friendsDisabled)) {
                            this.comboBoxMenu.add(friend);
                        }
                        for (JMenuItem p2pUser : new MultiIterable(p2pUsers, p2pUsersDisabled)) {
                            this.comboBoxMenu.add(p2pUser);
                        }
                        break block21;
                    }
                    if (friends.size() + friendsDisabled.size() != 1) break block23;
                    for (JMenuItem friend : new MultiIterable(friends, friendsDisabled)) {
                        if (friend instanceof JMenu) {
                            Component[] components;
                            for (Component component : components = ((JMenu)friend).getMenuComponents()) {
                                this.comboBoxMenu.add(component);
                            }
                            continue;
                        }
                        this.comboBoxMenu.add(friend);
                    }
                    break block21;
                }
                if (friends.size() + friendsDisabled.size() <= 1) break block24;
                for (JMenuItem friend : new MultiIterable(friends, friendsDisabled)) {
                    this.comboBoxMenu.add(friend);
                }
                break block21;
            }
            if (p2pUsers.size() + p2pUsersDisabled.size() <= 0) break block21;
            for (JMenuItem p2pUser : new MultiIterable(p2pUsers, p2pUsersDisabled)) {
                this.comboBoxMenu.add(p2pUser);
            }
        }
    }

    @Override
    public String getToolTipText() {
        return this.comboBox.getText();
    }

    public static enum RemoteWidgetType {
        SEARCH_LIST,
        TABLE,
        UPLOAD;

    }
}

