/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components.decorators;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Cursor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.components.decorators.ButtonDecorator;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.util.GuiUtils;

@Singleton
public class ComboBoxDecorator {
    private final ButtonDecorator buttonDecorator;
    @Resource
    private Icon miniRegIcon;
    @Resource
    private Icon miniHoverIcon;
    @Resource
    private Icon miniDownIcon;
    @Resource
    private Icon lightFullIcon;
    @Resource
    private Icon darkFullIcon;

    @Inject
    ComboBoxDecorator(ButtonDecorator buttonDecorator) {
        GuiUtils.assignResources(this);
        this.buttonDecorator = buttonDecorator;
    }

    public void decorateDarkFullComboBox(JXButton box) {
        this.buttonDecorator.decorateDarkFullButton(box);
        box.setIcon(this.darkFullIcon);
        box.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 20));
    }

    public void decorateDarkFullComboBox(JXButton box, BorderPainter.AccentType accentType) {
        this.buttonDecorator.decorateDarkFullButton(box, accentType);
        box.setIcon(this.darkFullIcon);
        box.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 20));
    }

    public void decorateLightFullComboBox(JXButton box) {
        this.buttonDecorator.decorateLightFullButton(box);
        box.setIcon(this.lightFullIcon);
        box.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 20));
    }

    public void decorateMiniComboBox(JXButton box) {
        this.buttonDecorator.decorateMiniButton(box);
        box.setIcon(this.miniRegIcon);
        box.setRolloverIcon(this.miniHoverIcon);
        box.setPressedIcon(this.miniDownIcon);
        box.setBorder(BorderFactory.createEmptyBorder(2, 6, 3, 6));
        this.tryInstallHandCursor(box);
    }

    public void decorateLinkComboBox(JXButton box) {
        this.buttonDecorator.decorateLinkButton(box);
        box.setIcon(this.miniRegIcon);
        box.setBorder(BorderFactory.createEmptyBorder(2, 6, 3, 6));
        this.tryInstallHandCursor(box);
    }

    public void decorateIconComboBox(JXButton box) {
        IconButton.setIconButtonProperties(box);
        this.tryInstallHandCursor(box);
    }

    private void tryInstallHandCursor(JXButton box) {
        box.setCursor(Cursor.getPredefinedCursor(12));
    }
}

