/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads.table;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.limewire.activation.api.ActivationManager;
import org.limewire.activation.api.ActivationModuleEvent;
import org.limewire.core.api.URN;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadState;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.listener.EventListener;
import org.limewire.ui.swing.downloads.DownloadItemUtils;
import org.limewire.ui.swing.downloads.table.DownloadActionHandler;
import org.limewire.ui.swing.downloads.table.DownloadPopupHandler;
import org.limewire.ui.swing.downloads.table.DownloadPopupHandlerFactory;
import org.limewire.ui.swing.downloads.table.DownloadTableModel;
import org.limewire.ui.swing.downloads.table.DownloadableTransferHandler;
import org.limewire.ui.swing.downloads.table.renderer.DownloadButtonRendererEditor;
import org.limewire.ui.swing.downloads.table.renderer.DownloadCancelRendererEditor;
import org.limewire.ui.swing.downloads.table.renderer.DownloadMessageRendererEditorFactory;
import org.limewire.ui.swing.downloads.table.renderer.DownloadProgressRenderer;
import org.limewire.ui.swing.downloads.table.renderer.DownloadTitleRenderer;
import org.limewire.ui.swing.table.TableDoubleClickHandler;
import org.limewire.ui.swing.transfer.TransferTable;
import org.limewire.ui.swing.util.GuiUtils;

public class DownloadTable
extends TransferTable<DownloadItem> {
    @Resource
    private int rowHeight;
    @Resource
    private int gapMinWidth;
    @Resource
    private int gapPrefWidth;
    @Resource
    private int gapMaxWidth;
    @Resource
    private int titleMinWidth;
    @Resource
    private int titlePrefWidth;
    @Resource
    private int titleMaxWidth;
    @Resource
    private int progressMinWidth;
    @Resource
    private int progressPrefWidth;
    @Resource
    private int progressMaxWidth;
    @Resource
    private int messageMinWidth;
    @Resource
    private int messagePrefWidth;
    @Resource
    private int messageMaxWidth;
    @Resource
    private int actionMinWidth;
    @Resource
    private int actionPrefWidth;
    @Resource
    private int actionMaxWidth;
    @Resource
    private int cancelMinWidth;
    @Resource
    private int cancelPrefWidth;
    @Resource
    private int cancelMaxWidth;
    private DownloadTableModel model;
    private EventList<DownloadItem> selectedItems;
    private final DownloadActionHandler actionHandler;
    private final CategoryManager categoryManager;
    private final DownloadMessageRendererEditorFactory messageRendererEditorFactory;
    private final DownloadProgressRenderer downloadProgressRenderer;
    private boolean isPro = false;

    @Inject
    public DownloadTable(DownloadTitleRenderer downloadTitleRenderer, DownloadProgressRenderer downloadProgressRenderer, DownloadMessageRendererEditorFactory messageRendererEditorFactory, DownloadCancelRendererEditor cancelEditor, DownloadButtonRendererEditor buttonEditor, DownloadActionHandler actionHandler, DownloadPopupHandlerFactory downloadPopupHandlerFactory, @Assisted EventList<DownloadItem> downloadItems, DownloadableTransferHandler downloadableTransferHandler, CategoryManager categoryManager) {
        super(new DownloadTableModel(downloadItems));
        this.actionHandler = actionHandler;
        this.categoryManager = categoryManager;
        this.messageRendererEditorFactory = messageRendererEditorFactory;
        this.downloadProgressRenderer = downloadProgressRenderer;
        GuiUtils.assignResources(this);
        this.initialize(downloadItems, buttonEditor, cancelEditor, downloadPopupHandlerFactory);
        this.addHighlighter(this.createDisabledHighlighter(new ThreatHighlightPredicate()));
        TransferTable.GapRenderer gapRenderer = new TransferTable.GapRenderer();
        this.setUpColumn(0, downloadTitleRenderer, this.titleMinWidth, this.titlePrefWidth, this.titleMaxWidth);
        this.setUpColumn(1, gapRenderer, this.gapMinWidth, this.gapPrefWidth, this.gapMaxWidth);
        this.setUpColumn(2, downloadProgressRenderer, this.progressMinWidth, this.progressPrefWidth, this.progressMaxWidth);
        this.setUpColumn(3, gapRenderer, this.gapMinWidth, this.gapPrefWidth, this.gapMaxWidth);
        this.setUpColumn(4, messageRendererEditorFactory.create(null), this.messageMinWidth, this.messagePrefWidth, this.messageMaxWidth);
        this.setUpColumn(5, gapRenderer, this.gapMinWidth, this.gapPrefWidth, this.gapMaxWidth);
        this.setUpColumn(6, new DownloadButtonRendererEditor(), this.actionMinWidth, this.actionPrefWidth, this.actionMaxWidth);
        this.setUpColumn(7, gapRenderer, this.gapMinWidth, this.gapPrefWidth, this.gapMaxWidth);
        this.setUpColumn(8, new DownloadCancelRendererEditor(), this.cancelMinWidth, this.cancelPrefWidth, this.cancelMaxWidth);
        this.setTransferHandler(downloadableTransferHandler);
        this.setDragEnabled(true);
        this.setRowHeight(this.rowHeight);
    }

    @Inject
    public void register(final ActivationManager activationManager) {
        this.isPro = activationManager.isProActive();
        activationManager.addModuleListener(new EventListener<ActivationModuleEvent>(){

            @Override
            public void handleEvent(ActivationModuleEvent event) {
                if (DownloadTable.this.isPro != activationManager.isProActive()) {
                    DownloadTable.this.isPro = activationManager.isProActive();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DownloadTable.this.downloadProgressRenderer.updateColor();
                        }
                    });
                }
            }
        });
    }

    public DownloadItem getDownloadItem(int row) {
        return this.model.getDownloadItem(this.convertRowIndexToModel(row));
    }

    public List<DownloadItem> getSelectedItems() {
        return new ArrayList<DownloadItem>(this.selectedItems);
    }

    public void selectAndScrollTo(URN urn) {
        if (urn != null) {
            for (int y = 0; y < this.model.getRowCount(); ++y) {
                DownloadItem item = this.getDownloadItem(y);
                if (item == null || item.getUrn() == null || !((Object)urn).equals(item.getUrn())) continue;
                this.getSelectionModel().setSelectionInterval(y, y);
                this.ensureRowVisible(y);
                break;
            }
        }
    }

    public void selectAndScrollTo(DownloadItem item) {
        for (int y = 0; y < this.model.getRowCount(); ++y) {
            if (item != this.getDownloadItem(y)) continue;
            this.getSelectionModel().setSelectionInterval(y, y);
            this.ensureRowVisible(y);
            break;
        }
    }

    private void setUpColumn(int index, TableCellRenderer renderer, int minWidth, int prefWidth, int maxWidth) {
        this.setColumnRenderer(index, renderer);
        this.setColumnWidths(index, minWidth, prefWidth, maxWidth);
    }

    private void initialize(EventList<DownloadItem> downloadItems, DownloadButtonRendererEditor buttonEditor, DownloadCancelRendererEditor cancelEditor, DownloadPopupHandlerFactory downloadPopupHandlerFactory) {
        this.model = (DownloadTableModel)this.getModel();
        DefaultEventSelectionModel<DownloadItem> model = new DefaultEventSelectionModel<DownloadItem>(downloadItems);
        this.setSelectionModel(model);
        model.setSelectionMode(103);
        this.selectedItems = model.getSelected();
        DownloadPopupHandler popupHandler = downloadPopupHandlerFactory.create(this);
        this.setPopupHandler(popupHandler);
        TableDoubleClickHandler clickHandler = new TableDoubleClickHandler(){

            @Override
            public void handleDoubleClick(int row) {
                DownloadTable.this.launch(row);
            }
        };
        this.setDoubleClickHandler(clickHandler);
        AbstractAction enterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = DownloadTable.this.getSelectedRow();
                if (row > -1) {
                    DownloadTable.this.launch(row);
                }
            }
        };
        this.setEnterKeyAction(enterAction);
        this.getColumnModel().getColumn(4).setCellEditor(this.messageRendererEditorFactory.create(this.actionHandler));
        this.getColumnModel().getColumn(6).setCellEditor(buttonEditor);
        this.getColumnModel().getColumn(8).setCellEditor(cancelEditor);
    }

    private void launch(int row) {
        DownloadItem item = this.getDownloadItem(row);
        if (item != null && item.isLaunchable()) {
            DownloadItemUtils.launch(item, this.categoryManager);
        }
    }

    private class ThreatHighlightPredicate
    implements HighlightPredicate {
        private ThreatHighlightPredicate() {
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            DownloadItem item = DownloadTable.this.getDownloadItem(adapter.row);
            DownloadState state = item.getState();
            return state == DownloadState.DANGEROUS || state == DownloadState.THREAT_FOUND || state == DownloadState.SCAN_FAILED;
        }
    }
}

