/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.friend.api.MessageWriter;
import org.limewire.inject.LazySingleton;
import org.limewire.listener.EventBroadcaster;
import org.limewire.ui.swing.friends.chat.ChatFriend;
import org.limewire.ui.swing.friends.chat.ChatFriendList;
import org.limewire.ui.swing.friends.chat.ChatHeader;
import org.limewire.ui.swing.friends.chat.ChatMediator;
import org.limewire.ui.swing.friends.chat.ChatMessageEvent;
import org.limewire.ui.swing.friends.chat.ChatPopupHandler;
import org.limewire.ui.swing.friends.chat.ChatStateEvent;
import org.limewire.ui.swing.friends.chat.ConversationPanel;
import org.limewire.ui.swing.friends.chat.MessageReaderImpl;
import org.limewire.ui.swing.friends.chat.MessageWriterImpl;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.ResizeUtils;

@LazySingleton
class ChatFrame
extends JPanel {
    @Resource
    private Color borderColor;
    @Resource
    private Color dividerColor;
    private final ChatHeader chatHeader;
    private final ChatFriendList chatList;
    private final ConversationPanel conversationPanel;
    private final ChatMediator chatMediator;
    private final EventBroadcaster<ChatMessageEvent> chatMessageList;
    private final EventBroadcaster<ChatStateEvent> chatStateList;

    @Inject
    public ChatFrame(ChatHeader chatHeader, ChatFriendList chatList, ConversationPanel conversationPanel, ChatPopupHandler popupHandler, ChatMediator chatMediator, EventBroadcaster<ChatMessageEvent> chatMessageList, EventBroadcaster<ChatStateEvent> chatStateList) {
        super(new MigLayout("gap 0, insets 0, fill"));
        this.chatHeader = chatHeader;
        this.chatList = chatList;
        this.conversationPanel = conversationPanel;
        this.chatMediator = chatMediator;
        this.chatMessageList = chatMessageList;
        this.chatStateList = chatStateList;
        GuiUtils.assignResources(this);
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, this.borderColor));
        this.add((Component)chatHeader.getComponent(), "dock north");
        JScrollPane scrollPane = new JScrollPane(chatList, 20, 31);
        scrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.dividerColor));
        ResizeUtils.forceWidth(scrollPane, 122);
        chatList.setPopupHandler(popupHandler);
        this.add((Component)scrollPane, "dock west");
        this.add((Component)conversationPanel.getComponent(), "dock center");
    }

    @Inject
    public void register() {
        this.chatList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ChatFrame.this.chatList.getSelectedRow() >= 0 && ChatFrame.this.chatList.getSelectedRow() < ChatFrame.this.chatList.getRowCount()) {
                    ChatFriend chatFriend = (ChatFriend)ChatFrame.this.chatList.getModel().getValueAt(ChatFrame.this.chatList.getSelectedRow(), 0);
                    if (ChatFrame.this.conversationPanel.hasConversation(chatFriend)) {
                        ChatFrame.this.chatHeader.setFriend(chatFriend);
                        ChatFrame.this.conversationPanel.displayConverstaion(chatFriend);
                    }
                }
            }
        });
        this.chatList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && (index = ChatFrame.this.chatList.rowAtPoint(e.getPoint())) >= 0 && index < ChatFrame.this.chatList.getRowCount()) {
                    ChatFriend chatFriend = (ChatFriend)ChatFrame.this.chatList.getModel().getValueAt(ChatFrame.this.chatList.getSelectedRow(), 0);
                    ChatFrame.this.selectOrStartConversation(chatFriend);
                }
            }
        });
    }

    public void selectOrStartConversation(ChatFriend chatFriend) {
        if (!this.conversationPanel.hasConversation(chatFriend)) {
            this.startConversation(chatFriend, this.createMessageWriter(chatFriend));
        } else {
            this.conversationPanel.displayConverstaion(chatFriend);
            this.chatHeader.setFriend(chatFriend);
            this.chatList.repaint();
        }
        this.chatMediator.getChatButton().repaint();
    }

    private MessageWriter createMessageWriter(ChatFriend chatFriend) {
        MessageWriter writer = chatFriend.createChat(new MessageReaderImpl(chatFriend, this.chatMessageList, this.chatStateList));
        MessageWriterImpl messageWriter = new MessageWriterImpl(chatFriend, writer, this.chatMessageList);
        return messageWriter;
    }

    public void startConversation(ChatFriend chatFriend, MessageWriter messageWriter) {
        if (!this.conversationPanel.hasConversation(chatFriend)) {
            chatFriend.startChat();
            this.conversationPanel.startNewChat(chatFriend, messageWriter);
            this.chatHeader.setFriend(chatFriend);
            this.chatList.repaint();
        }
    }

    public ChatFriend getSelectedConversation() {
        return this.conversationPanel.getCurrentConversationFriend();
    }

    public void closeAllChats() {
        this.chatHeader.clearFriend();
        this.conversationPanel.removeAllConversations();
        this.chatList.repaint();
        this.chatMediator.getChatButton().repaint();
    }

    public void closeConversation(ChatFriend chatFriend) {
        this.chatHeader.clearFriend();
        this.conversationPanel.removeConversation(chatFriend);
        this.chatList.repaint();
        this.chatMediator.getChatButton().repaint();
    }
}

