/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import org.limewire.concurrent.ThreadExecutor;
import org.limewire.friend.api.ChatState;
import org.limewire.friend.api.FriendException;
import org.limewire.friend.api.MessageWriter;
import org.limewire.listener.EventBroadcaster;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.friends.chat.ChatFriend;
import org.limewire.ui.swing.friends.chat.ChatMessageEvent;
import org.limewire.ui.swing.friends.chat.ErrorMessage;
import org.limewire.ui.swing.friends.chat.Message;
import org.limewire.ui.swing.friends.chat.MessageTextImpl;
import org.limewire.ui.swing.util.I18n;

class MessageWriterImpl
implements MessageWriter {
    private static final Log LOG = LogFactory.getLog(MessageWriterImpl.class);
    private final ChatFriend chatFriend;
    private final MessageWriter writer;
    private final EventBroadcaster<ChatMessageEvent> messageList;

    MessageWriterImpl(ChatFriend chatFriend, MessageWriter writer, EventBroadcaster<ChatMessageEvent> messageList) {
        this.chatFriend = chatFriend;
        this.writer = writer;
        this.messageList = messageList;
    }

    @Override
    public void writeMessage(final String message) throws FriendException {
        MessageTextImpl msg = new MessageTextImpl(I18n.tr("me"), this.chatFriend.getID(), Message.Type.SENT, message);
        if (this.chatFriend.isSignedIn()) {
            ThreadExecutor.startThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MessageWriterImpl.this.writer.writeMessage(message);
                    }
                    catch (FriendException e) {
                        LOG.error("send message failed", e);
                    }
                }
            }, "send-message");
            this.messageList.broadcast(new ChatMessageEvent(msg));
        } else {
            String errorMsg = I18n.tr("Message not sent because friend signed off.");
            ErrorMessage error = new ErrorMessage(errorMsg, msg);
            this.messageList.broadcast(new ChatMessageEvent(error));
        }
    }

    @Override
    public void setChatState(final ChatState chatState) throws FriendException {
        if (this.chatFriend.isSignedIn()) {
            ThreadExecutor.startThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MessageWriterImpl.this.writer.setChatState(chatState);
                    }
                    catch (FriendException e) {
                        LOG.error("set chat state failed", e);
                    }
                }
            }, "set-chat-state");
        }
    }
}

