/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.refresh;

import com.google.inject.Inject;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.limewire.core.api.library.RemoteLibraryEvent;
import org.limewire.core.api.library.RemoteLibraryManager;
import org.limewire.core.api.search.browse.BrowseSearch;
import org.limewire.inject.EagerSingleton;
import org.limewire.listener.EventListener;
import org.limewire.ui.swing.friends.refresh.BrowseRefreshStatus;
import org.limewire.ui.swing.friends.refresh.BrowseRefreshStatusListener;
import org.limewire.ui.swing.search.DefaultSearchRepeater;
import org.limewire.ui.swing.search.SearchRepeater;
import org.limewire.ui.swing.search.model.SearchResultsModel;

@EagerSingleton
public class AllFriendsRefreshManager
implements SearchRepeater {
    private static final long DELAY = 10000L;
    private final RemoteLibraryManager remoteLibraryManager;
    private long earliestPossibleFiringTime = 0L;
    private boolean hasInsert = false;
    private boolean hasDelete = false;
    private BrowseSearch allFriendsBrowse;
    private SearchResultsModel allFriendsModel;
    private final Timer delayTimer = new DelayTimer();
    private ArrayList<BrowseRefreshStatusListener> statusListeners = new ArrayList();

    @Inject
    public AllFriendsRefreshManager(RemoteLibraryManager remoteLibraryManager) {
        this.remoteLibraryManager = remoteLibraryManager;
    }

    @Inject
    public void register() {
        this.remoteLibraryManager.getAllFriendsLibrary().addListener(new EventListener<RemoteLibraryEvent>(){

            @Override
            public void handleEvent(RemoteLibraryEvent event) {
                switch ((RemoteLibraryEvent.Type)((Object)event.getType())) {
                    case RESULTS_ADDED: {
                        AllFriendsRefreshManager.this.hasInsert = true;
                        break;
                    }
                    case RESULTS_CLEARED: 
                    case RESULTS_REMOVED: {
                        AllFriendsRefreshManager.this.hasDelete = true;
                    }
                }
                AllFriendsRefreshManager.this.fireCurrentStatus();
            }
        });
    }

    public void addBrowseRefreshStatusListener(BrowseRefreshStatusListener listener) {
        this.statusListeners.add(listener);
    }

    public void removeBrowseRefreshStatusListener(BrowseRefreshStatusListener listener) {
        this.statusListeners.remove(listener);
    }

    private void fireCurrentStatus() {
        if (!this.delayTimer.isRunning()) {
            long delayRemaining = this.earliestPossibleFiringTime - System.currentTimeMillis();
            if (delayRemaining <= 0L) {
                this.fireCurrentStatusNow();
            } else {
                this.delayTimer.setInitialDelay((int)delayRemaining);
                this.delayTimer.start();
            }
        }
    }

    private void fireCurrentStatusNow() {
        boolean bl = this.hasInsert = this.hasInsert && this.hasSharedFiles();
        if (this.hasInsert && this.hasDelete) {
            this.fireRefreshStatusChange(BrowseRefreshStatus.CHANGED);
        } else if (this.hasInsert) {
            this.fireRefreshStatusChange(BrowseRefreshStatus.ADDED);
        } else if (this.hasDelete) {
            this.fireRefreshStatusChange(BrowseRefreshStatus.REMOVED);
        }
    }

    public void registerBrowseSearch(BrowseSearch allFriendsBrowse, SearchResultsModel allFriendsModel) {
        this.allFriendsBrowse = allFriendsBrowse;
        this.allFriendsModel = allFriendsModel;
        this.fireRefreshed();
    }

    public void clearBrowseSearch() {
        this.allFriendsBrowse = null;
        this.allFriendsModel = null;
    }

    @Override
    public void refresh() {
        if (this.needsRefresh()) {
            new DefaultSearchRepeater(this.allFriendsBrowse, this.allFriendsModel).refresh();
            this.fireRefreshed();
        }
    }

    private void fireRefreshed() {
        this.hasInsert = false;
        this.hasDelete = false;
        this.delayTimer.stop();
        this.fireRefreshStatusChange(BrowseRefreshStatus.REFRESHED);
    }

    private void fireRefreshStatusChange(final BrowseRefreshStatus status) {
        this.earliestPossibleFiringTime = System.currentTimeMillis() + 10000L;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (BrowseRefreshStatusListener listener : AllFriendsRefreshManager.this.statusListeners) {
                    listener.statusChanged(status);
                }
            }
        });
    }

    public boolean needsRefresh() {
        return this.hasInsert || this.hasDelete;
    }

    public boolean hasSharedFiles() {
        return this.remoteLibraryManager.getAllFriendsLibrary().size() > 0;
    }

    private class FireStatusChangeAction
    extends AbstractAction {
        private FireStatusChangeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AllFriendsRefreshManager.this.fireCurrentStatusNow();
        }
    }

    private class DelayTimer
    extends Timer {
        public DelayTimer() {
            super(0, new FireStatusChangeAction());
            this.setRepeats(false);
        }
    }
}

