/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.images;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.limewire.ui.swing.util.GraphicsUtilities;
import org.limewire.util.FileUtils;

public class ThumbnailCallable
implements Callable<Void> {
    private final Map<File, Icon> thumbnailMap;
    private final Map<File, String> loadingMap;
    private File file;
    private final Icon errorIcon;
    private final JComponent callback;
    private int index = -1;
    private static final float subSamplingFactor = 487.19998f;

    public ThumbnailCallable(Map<File, Icon> thumbnailMap, Map<File, String> loadingMap, File file, Icon errorIcon) {
        this(thumbnailMap, loadingMap, file, errorIcon, null);
    }

    public ThumbnailCallable(Map<File, Icon> thumbnailMap, Map<File, String> loadingMap, File file, Icon errorIcon, JComponent callback) {
        this.thumbnailMap = thumbnailMap;
        this.loadingMap = loadingMap;
        this.file = file;
        this.errorIcon = errorIcon;
        this.callback = callback;
    }

    public ThumbnailCallable(Map<File, Icon> thumbnailMap, Map<File, String> loadingMap, File file, Icon errorIcon, JList list, int index) {
        this.thumbnailMap = thumbnailMap;
        this.loadingMap = loadingMap;
        this.file = file;
        this.errorIcon = errorIcon;
        this.callback = list;
        this.index = index;
    }

    @Override
    public Void call() throws Exception {
        if (this.callback != null) {
            if (!this.callback.isShowing()) {
                this.loadingMap.remove(this.file);
                return null;
            }
            if (this.callback instanceof JList && this.index != -1 && (((JList)this.callback).getFirstVisibleIndex() > this.index || ((JList)this.callback).getLastVisibleIndex() < this.index)) {
                this.loadingMap.remove(this.file);
                return null;
            }
        }
        BufferedImage image = null;
        try {
            image = this.getSubSampleImage(this.file);
        }
        catch (Throwable e) {
            try {
                image = ImageIO.read(this.file);
            }
            catch (Throwable ee) {
                this.handleUpdate(this.errorIcon);
                return null;
            }
        }
        if (image == null) {
            this.handleUpdate(this.errorIcon);
            return null;
        }
        if (image.getWidth() > 116 || image.getHeight() > 86) {
            try {
                image = GraphicsUtilities.createRatioPreservedThumbnail(image, 116, 86);
            }
            catch (Throwable t) {
                try {
                    image = GraphicsUtilities.createRatioPreservedThumbnailFast(image, 116, 86);
                }
                catch (Throwable e) {
                    image = null;
                }
            }
        } else {
            image = GraphicsUtilities.toCompatibleImage(image);
        }
        if (image == null || image.getWidth() == 0 || image.getHeight() == 0) {
            this.handleUpdate(this.errorIcon);
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(image);
        this.handleUpdate(imageIcon);
        return null;
    }

    private void handleUpdate(Icon icon) {
        this.thumbnailMap.put(this.file, icon);
        this.loadingMap.remove(this.file);
        if (this.callback != null && this.callback.isShowing()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ThumbnailCallable.this.callback.repaint();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getSubSampleImage(File file) throws FileNotFoundException, IOException {
        BufferedImage image;
        ImageInputStream bufferedInput = null;
        try {
            ImageReader imgReader = ImageIO.getImageReadersBySuffix(FileUtils.getFileExtension(file)).next();
            bufferedInput = ImageIO.createImageInputStream(new BufferedInputStream(new FileInputStream(file)));
            imgReader.setInput(bufferedInput);
            int imgHeight = imgReader.getHeight(0);
            int imgWidth = imgReader.getWidth(0);
            int longEdge = Math.max(imgHeight, imgWidth);
            int subSample = (int)((float)longEdge / 487.19998f);
            ImageReadParam readParam = imgReader.getDefaultReadParam();
            if (subSample > 1) {
                readParam.setSourceSubsampling(subSample, subSample, 0, 0);
            }
            image = imgReader.read(0, readParam);
        }
        finally {
            if (bufferedInput != null) {
                bufferedInput.close();
            }
        }
        return image;
    }
}

