/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.images;

import com.google.inject.Inject;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jdesktop.application.Resource;
import org.limewire.collection.FixedsizeForgetfulHashMap;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.images.ImageExecutorService;
import org.limewire.ui.swing.images.ThumbnailCallable;
import org.limewire.ui.swing.images.ThumbnailManager;
import org.limewire.ui.swing.util.GuiUtils;

@LazySingleton
public class ThumbnailManagerImpl
implements ThumbnailManager {
    private final Map<File, Icon> thumbnails = new FixedsizeForgetfulHashMap<File, Icon>(2000);
    private final Map<File, String> loading = new HashMap<File, String>();
    @Resource
    private Icon loadIcon;
    @Resource
    private Icon errorIcon;

    @Inject
    public ThumbnailManagerImpl() {
        GuiUtils.assignResources(this);
    }

    @Override
    public Icon getThumbnailForFile(File file) {
        if (file == null) {
            return null;
        }
        Icon icon = this.thumbnails.get(file);
        if (icon == null) {
            icon = this.loadIcon;
            if (!this.loading.containsKey(file)) {
                this.loading.put(file, "");
                ImageExecutorService.submit(new ThumbnailCallable(this.thumbnails, this.loading, file, this.errorIcon));
            }
        }
        return icon;
    }

    @Override
    public Icon getThumbnailForFile(File file, JComponent callback) {
        if (file == null) {
            return null;
        }
        Icon icon = this.thumbnails.get(file);
        if (icon == null) {
            icon = this.loadIcon;
            if (!this.loading.containsKey(file)) {
                this.loading.put(file, "");
                ImageExecutorService.submit(new ThumbnailCallable(this.thumbnails, this.loading, file, this.errorIcon, callback));
            }
        }
        return icon;
    }

    @Override
    public Icon getThumbnailForFile(File file, JList list, int index) {
        if (file == null) {
            return null;
        }
        Icon icon = this.thumbnails.get(file);
        if (icon == null) {
            icon = this.loadIcon;
            if (!this.loading.containsKey(file)) {
                this.loading.put(file, "");
                ImageExecutorService.submit(new ThumbnailCallable(this.thumbnails, this.loading, file, this.errorIcon, list, index));
            }
        }
        return icon;
    }

    @Override
    public boolean isThumbnailForFileAvailable(File file) {
        return this.thumbnails.containsKey(file);
    }

    @Override
    public boolean isErrorIcon(File file) {
        return this.thumbnails.containsKey(file) && this.thumbnails.get(file).equals(this.errorIcon);
    }
}

