/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.Application;
import org.limewire.ui.swing.options.LearnMoreButton;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class PublicSharedFeedbackPanel {
    private final Application application;
    @Resource
    private Icon publicSharedIcon;
    @Resource
    private Color backgroundColor;
    @Resource
    private Color foregroundColor;
    @Resource
    private Color borderColor;
    @Resource
    private Font labelFont;
    private final JPanel component;

    @Inject
    public PublicSharedFeedbackPanel(Application application) {
        this.application = application;
        GuiUtils.assignResources(this);
        this.component = new JPanel(new MigLayout("insets 0 5 0 0", "", "[25!]"));
        this.component.setVisible(false);
        this.init();
    }

    private void init() {
        this.component.setBackground(this.backgroundColor);
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, this.borderColor));
        JLabel label = new JLabel(I18n.tr("Files in this list are shared anonymously with the world."), this.publicSharedIcon, 2);
        label.setForeground(this.foregroundColor);
        label.setFont(this.labelFont);
        this.component.add(label);
        String learnMoreUrl = "http://www.limewire.com/client_redirect/?page=publicSharing";
        LearnMoreButton learnMoreButton = new LearnMoreButton("http://www.limewire.com/client_redirect/?page=publicSharing", this.application);
        this.component.add(learnMoreButton);
    }

    public JComponent getComponent() {
        return this.component;
    }
}

