/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.mainframe;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.network.BandwidthCollector;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.core.settings.UploadSettings;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.components.FancyTab;
import org.limewire.ui.swing.components.FancyTabList;
import org.limewire.ui.swing.components.LimeComboBox;
import org.limewire.ui.swing.components.TabActionMap;
import org.limewire.ui.swing.components.decorators.ComboBoxDecorator;
import org.limewire.ui.swing.dock.DockIconFactory;
import org.limewire.ui.swing.downloads.DownloadMediator;
import org.limewire.ui.swing.listener.MousePopupListener;
import org.limewire.ui.swing.mainframe.BottomPanel;
import org.limewire.ui.swing.painter.factories.BarPainterFactory;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.transfer.TransferTrayNavigator;
import org.limewire.ui.swing.upload.UploadMediator;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.ResizeUtils;
import org.limewire.ui.swing.util.SwingUtils;

@Singleton
public class BottomHeaderPanel
implements TransferTrayNavigator {
    @InspectablePrimitive(value="upload view", category=DataCategory.USAGE)
    private static volatile int uploadsViewed = 0;
    @Resource
    private Icon moreButtonArrow;
    @Resource
    private Icon scrollPaneNubIcon;
    @Resource
    private Font hyperlinkFont;
    @Resource(key="HyperlinkButtonResources.foreground")
    private Color hyperlinkForeground;
    @Resource
    private Color highlightBackground;
    @Resource
    private Color highlightBorderColor;
    @Resource
    private Color selectionTopGradientColor;
    @Resource
    private Color selectionBottomGradientColor;
    @Resource
    private Color selectionTopBorderColor;
    @Resource
    private Color selectionBottomBorderColor;
    @Resource
    private Font textFont;
    @Resource
    private Color textForeground;
    @Resource
    private Color textSelectedForeground;
    private final DownloadMediator downloadMediator;
    private final UploadMediator uploadMediator;
    private final ComboBoxDecorator comboBoxDecorator;
    private final BandwidthCollector bandwidthCollector;
    private final BottomPanel bottomPanel;
    private final JXPanel component;
    private JComponent dragComponent;
    private Map<BottomPanel.TabId, Action> actionMap = new EnumMap<BottomPanel.TabId, Action>(BottomPanel.TabId.class);
    private List<TabActionMap> tabActionList;
    private FancyTabList tabList;
    private JLabel titleTextLabel;
    private JPanel downloadButtonPanel;
    private JPanel uploadButtonPanel;
    private LimeComboBox downloadOptionsButton;
    private LimeComboBox uploadOptionsButton;
    private int componentHeight;
    private JSplitPane parentSplitPane;

    @Inject
    public BottomHeaderPanel(DownloadMediator downloadMediator, UploadMediator uploadMediator, ComboBoxDecorator comboBoxDecorator, BarPainterFactory barPainterFactory, DockIconFactory iconFactory, BandwidthCollector bandwidthCollector, BottomPanel bottomPanel) {
        this.downloadMediator = downloadMediator;
        this.uploadMediator = uploadMediator;
        this.comboBoxDecorator = comboBoxDecorator;
        this.bandwidthCollector = bandwidthCollector;
        this.bottomPanel = bottomPanel;
        GuiUtils.assignResources(this);
        this.hyperlinkFont = FontUtils.deriveUnderline(this.hyperlinkFont, true);
        this.component = new JXPanel(new MigLayout("insets 0 0 0 0, gap 0, novisualpadding, fill"));
        this.component.setBackgroundPainter(barPainterFactory.createDownloadSummaryBarPainter());
        this.setComponentHeight(20);
        iconFactory.createDockIcon();
        this.initialize();
    }

    public JComponent getComponent() {
        return this.component;
    }

    public JComponent getDragComponent() {
        return this.dragComponent;
    }

    private void initialize() {
        this.initializeComponents();
        this.initializeTabList();
        this.layoutComponents();
        this.updateSelection();
    }

    private void initializeComponents() {
        this.titleTextLabel = new JLabel(I18n.tr("Downloads"));
        this.titleTextLabel.setFont(this.textFont);
        this.titleTextLabel.setForeground(this.textForeground);
        this.dragComponent = new JLabel(this.scrollPaneNubIcon);
        this.dragComponent.setCursor(Cursor.getPredefinedCursor(9));
        this.downloadButtonPanel = new JPanel(new MigLayout("insets 0 0 0 0, gap 0, novisualpadding"));
        this.downloadButtonPanel.setOpaque(false);
        this.uploadButtonPanel = new JPanel(new MigLayout("insets 0 0 0 0, gap 0, novisualpadding"));
        this.uploadButtonPanel.setOpaque(false);
        this.initializeOptionsButton();
        this.component.addMouseListener(new MousePopupListener(){

            @Override
            public void handlePopupMouseEvent(MouseEvent e) {
                JPopupMenu popupMenu = null;
                if (BottomHeaderPanel.this.downloadButtonPanel.isVisible()) {
                    popupMenu = BottomHeaderPanel.this.downloadMediator.getHeaderPopupMenu();
                } else if (BottomHeaderPanel.this.uploadButtonPanel.isVisible()) {
                    popupMenu = BottomHeaderPanel.this.uploadMediator.getHeaderPopupMenu();
                }
                if (popupMenu != null) {
                    popupMenu.show(BottomHeaderPanel.this.component, e.getX(), e.getY());
                }
            }
        });
    }

    private void layoutComponents() {
        List<JButton> downloadButtons = this.downloadMediator.getHeaderButtons();
        for (JButton button : downloadButtons) {
            button.setFont(this.hyperlinkFont);
            this.downloadButtonPanel.add((Component)button, "gapafter 5");
        }
        this.downloadButtonPanel.add((Component)this.downloadOptionsButton, "gapafter 5");
        List<JButton> uploadButtons = this.uploadMediator.getHeaderButtons();
        for (JButton button : uploadButtons) {
            button.setFont(this.hyperlinkFont);
            this.uploadButtonPanel.add((Component)button, "gapafter 5");
        }
        this.uploadButtonPanel.add((Component)this.uploadOptionsButton, "gapafter 5");
        this.component.add((Component)this.tabList, "growy, push, hidemode 3");
        this.component.add((Component)this.titleTextLabel, "gapbefore 5, push, hidemode 3");
        this.component.add((Component)this.downloadButtonPanel, "hidemode 3");
        this.component.add((Component)this.uploadButtonPanel, "hidemode 3");
        this.component.add((Component)this.dragComponent, "pos 0.5al 0");
    }

    @Inject
    public void register() {
        this.downloadMediator.getActiveList().addListEventListener(new LabelUpdateListListener());
        this.uploadMediator.getActiveList().addListEventListener(new ListEventListener<UploadItem>(){

            @Override
            public void listChanged(ListEvent<UploadItem> listChanges) {
                BottomHeaderPanel.this.updateUploadTitle();
            }
        });
        SwingUiSettings.SHOW_TRANSFERS_TRAY.addSettingListener(new SettingListener(){

            @Override
            public void settingChanged(SettingEvent evt) {
                SwingUtils.invokeNowOrLater(new Runnable(){

                    @Override
                    public void run() {
                        BottomHeaderPanel.this.updateSelection();
                    }
                });
            }
        });
        UploadSettings.SHOW_UPLOADS_IN_TRAY.addSettingListener(new SettingListener(){

            @Override
            public void settingChanged(SettingEvent evt) {
                SwingUtils.invokeNowOrLater(new Runnable(){

                    @Override
                    public void run() {
                        BottomHeaderPanel.this.updateSelection();
                    }
                });
            }
        });
    }

    private void initializeOptionsButton() {
        this.downloadOptionsButton = new LimeComboBox();
        this.downloadOptionsButton.setText(I18n.tr("Options"));
        this.comboBoxDecorator.decorateMiniComboBox(this.downloadOptionsButton);
        this.downloadOptionsButton.setFocusable(false);
        this.downloadOptionsButton.setFont(this.hyperlinkFont);
        this.downloadOptionsButton.setIcon(this.moreButtonArrow);
        this.downloadOptionsButton.setForeground(this.hyperlinkForeground);
        ResizeUtils.forceHeight(this.downloadOptionsButton, 16);
        this.downloadOptionsButton.overrideMenu(this.downloadMediator.getHeaderPopupMenu());
        this.uploadOptionsButton = new LimeComboBox();
        this.uploadOptionsButton.setText(I18n.tr("Options"));
        this.comboBoxDecorator.decorateMiniComboBox(this.uploadOptionsButton);
        this.uploadOptionsButton.setFocusable(false);
        this.uploadOptionsButton.setFont(this.hyperlinkFont);
        this.uploadOptionsButton.setIcon(this.moreButtonArrow);
        this.uploadOptionsButton.setForeground(this.hyperlinkForeground);
        ResizeUtils.forceHeight(this.uploadOptionsButton, 16);
        this.uploadOptionsButton.overrideMenu(this.uploadMediator.getHeaderPopupMenu());
    }

    private void initializeTabList() {
        ShowDownloadsAction downloadAction = new ShowDownloadsAction();
        ShowUploadsAction uploadAction = new ShowUploadsAction();
        this.actionMap.put(BottomPanel.TabId.DOWNLOADS, downloadAction);
        this.actionMap.put(BottomPanel.TabId.UPLOADS, uploadAction);
        this.tabActionList = TabActionMap.createMapForMainActions(downloadAction, uploadAction);
        this.tabList = new FancyTabList(this.tabActionList);
        this.tabList.setTabTextColor(this.textForeground);
        this.tabList.setTextFont(this.textFont);
        this.tabList.setTabTextSelectedColor(this.textSelectedForeground);
        this.tabList.setUnderlineEnabled(false);
        this.tabList.setSelectionPainter(new TabPainter(this.selectionTopGradientColor, this.selectionBottomGradientColor, this.selectionTopBorderColor, this.selectionBottomBorderColor));
        this.tabList.setHighlightPainter(new TabPainter(this.highlightBackground, this.highlightBackground, this.highlightBorderColor, this.highlightBorderColor));
        this.selectTab(BottomPanel.TabId.UPLOADS);
        this.selectTab(BottomPanel.TabId.DOWNLOADS);
    }

    public int getComponentHeight() {
        return this.componentHeight;
    }

    private void setComponentHeight(int height) {
        this.componentHeight = height;
        ResizeUtils.forceHeight(this.component, height);
        if (this.parentSplitPane != null) {
            this.parentSplitPane.setDividerSize(height);
        }
    }

    public void setParentSplitPane(JSplitPane splitPane) {
        this.parentSplitPane = splitPane;
    }

    public void selectTab(BottomPanel.TabId tabId) {
        Action mainAction = this.actionMap.get((Object)tabId);
        List<FancyTab> tabs = this.tabList.getTabs();
        for (FancyTab tab : tabs) {
            if (mainAction != tab.getTabActionMap().getMainAction()) continue;
            tab.select();
            break;
        }
    }

    private void select(BottomPanel.TabId tabId) {
        this.bottomPanel.show(tabId);
        this.updateHeader(tabId);
    }

    private void updateHeader(BottomPanel.TabId tabId) {
        switch (tabId) {
            case DOWNLOADS: {
                this.updateDownloadTitle();
                this.downloadButtonPanel.setVisible(true);
                this.uploadButtonPanel.setVisible(false);
                break;
            }
            case UPLOADS: {
                this.updateUploadTitle();
                this.downloadButtonPanel.setVisible(false);
                this.uploadButtonPanel.setVisible(true);
            }
        }
    }

    private void updateLayout() {
        boolean downloadVisible = SwingUiSettings.SHOW_TRANSFERS_TRAY.getValue();
        boolean uploadVisible = UploadSettings.SHOW_UPLOADS_IN_TRAY.getValue();
        if (downloadVisible && uploadVisible) {
            this.tabList.setVisible(true);
            this.titleTextLabel.setVisible(false);
            this.setComponentHeight(26);
        } else {
            this.tabList.setVisible(false);
            this.titleTextLabel.setVisible(true);
            this.setComponentHeight(20);
        }
    }

    private void updateSelection() {
        boolean downloadVisible = SwingUiSettings.SHOW_TRANSFERS_TRAY.getValue();
        boolean uploadVisible = UploadSettings.SHOW_UPLOADS_IN_TRAY.getValue();
        if (this.tabList.getSelectedTab() == null || downloadVisible && !uploadVisible) {
            this.selectTab(BottomPanel.TabId.DOWNLOADS);
        }
        this.updateLayout();
    }

    private void updateDownloadTitle() {
        String title;
        int size = this.downloadMediator.getActiveList().size();
        if (SwingUiSettings.SHOW_TOTAL_BANDWIDTH.getValue()) {
            int bandwidth = this.bandwidthCollector.getCurrentDownloaderBandwidth();
            title = size > 0 ? I18n.tr("Downloads ({0} at {1} KB/s)", size, bandwidth) : I18n.tr("Downloads");
        } else {
            title = size > 0 ? I18n.tr("Downloads ({0})", size) : I18n.tr("Downloads");
        }
        this.actionMap.get((Object)BottomPanel.TabId.DOWNLOADS).putValue("Name", title);
        this.titleTextLabel.setText(title);
    }

    private void updateUploadTitle() {
        String title;
        int size = this.uploadMediator.getActiveList().size();
        if (SwingUiSettings.SHOW_TOTAL_BANDWIDTH.getValue()) {
            int bandwidth = this.bandwidthCollector.getCurrentUploaderBandwidth();
            title = size > 0 ? I18n.tr("Uploads ({0} at {1} KB/s)", size, bandwidth) : I18n.tr("Uploads");
        } else {
            title = size > 0 ? I18n.tr("Uploads ({0})", size) : I18n.tr("Uploads");
        }
        this.actionMap.get((Object)BottomPanel.TabId.UPLOADS).putValue("Name", title);
    }

    private boolean isSelectedTab(BottomPanel.TabId tabId) {
        Action mainAction = this.actionMap.get((Object)tabId);
        FancyTab tab = this.tabList.getSelectedTab();
        return tab != null && mainAction == tab.getTabActionMap().getMainAction();
    }

    @Override
    public void selectDownloads() {
        this.showTray();
        this.selectTab(BottomPanel.TabId.DOWNLOADS);
    }

    @Override
    public void selectUploads() {
        this.showTray();
        UploadSettings.SHOW_UPLOADS_IN_TRAY.setValue(true);
        this.selectTab(BottomPanel.TabId.UPLOADS);
    }

    @Override
    public void hideTray() {
        SwingUiSettings.SHOW_TRANSFERS_TRAY.setValue(false);
    }

    @Override
    public boolean isDownloadsSelected() {
        return this.isSelectedTab(BottomPanel.TabId.DOWNLOADS);
    }

    @Override
    public boolean isTrayShowing() {
        return SwingUiSettings.SHOW_TRANSFERS_TRAY.getValue();
    }

    @Override
    public boolean isUploadsSelected() {
        return this.isSelectedTab(BottomPanel.TabId.UPLOADS);
    }

    @Override
    public void showTray() {
        SwingUiSettings.SHOW_TRANSFERS_TRAY.setValue(true);
    }

    private static class TabPainter
    extends RectanglePainter<FancyTab> {
        public TabPainter(Color topGradient, Color bottomGradient, Color topBorder, Color bottomBorder) {
            this.setFillPaint(new GradientPaint(0.0f, 0.0f, topGradient, 0.0f, 1.0f, bottomGradient));
            this.setBorderPaint(new GradientPaint(0.0f, 0.0f, topBorder, 0.0f, 1.0f, bottomBorder));
            this.setRoundHeight(10);
            this.setRoundWidth(10);
            this.setRounded(true);
            this.setPaintStretched(true);
            this.setInsets(new Insets(2, 0, 1, 0));
            this.setAntialiasing(true);
            this.setCacheable(true);
        }
    }

    private class ShowUploadsAction
    extends AbstractAction {
        private ShowUploadsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BottomHeaderPanel.this.select(BottomPanel.TabId.UPLOADS);
            uploadsViewed++;
        }
    }

    private class ShowDownloadsAction
    extends AbstractAction {
        private ShowDownloadsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BottomHeaderPanel.this.select(BottomPanel.TabId.DOWNLOADS);
        }
    }

    private class LabelUpdateListListener
    implements ListEventListener<DownloadItem> {
        private LabelUpdateListListener() {
        }

        @Override
        public void listChanged(ListEvent<DownloadItem> listChanges) {
            BottomHeaderPanel.this.updateDownloadTitle();
        }
    }
}

