/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.player;

import com.google.inject.Provider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicSliderUI;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.Painter;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.player.api.PlayerState;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.components.LimeSliderBar;
import org.limewire.ui.swing.components.MarqueeButton;
import org.limewire.ui.swing.components.VolumeSlider;
import org.limewire.ui.swing.components.decorators.SliderBarDecorator;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.painter.ComponentBackgroundPainter;
import org.limewire.ui.swing.player.PlayerInspectionUtils;
import org.limewire.ui.swing.player.PlayerMediator;
import org.limewire.ui.swing.player.PlayerMediatorListener;
import org.limewire.ui.swing.player.PlayerUtils;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.ResizeUtils;

class PlayerControlPanel
extends JXPanel
implements PlayerMediatorListener,
Disposable {
    @Resource
    private int arcWidth;
    @Resource
    private int arcHeight;
    @Resource
    private Color innerBorder;
    @Resource
    private Color innerBackground;
    @Resource
    private Color bevelLeft;
    @Resource
    private Color bevelTop1;
    @Resource
    private Color bevelTop2;
    @Resource
    private Color bevelRight;
    @Resource
    private Color bevelBottom;
    @Resource
    private Icon backIcon;
    @Resource
    private Icon backIconPressed;
    @Resource
    private Icon backIconRollover;
    @Resource
    private Icon backIconDisabled;
    @Resource
    private Icon forwardIcon;
    @Resource
    private Icon forwardIconPressed;
    @Resource
    private Icon forwardIconRollover;
    @Resource
    private Icon forwardIconDisabled;
    @Resource
    private Icon playIcon;
    @Resource
    private Icon playIconPressed;
    @Resource
    private Icon playIconRollover;
    @Resource
    private Icon playIconDisabled;
    @Resource
    private Icon pauseIcon;
    @Resource
    private Icon pauseIconPressed;
    @Resource
    private Icon pauseIconRollover;
    @Resource
    private Icon volumeIcon;
    @Resource
    private Icon volumeIconPressed;
    @Resource
    private Icon volumeIconRollover;
    @Resource
    private Icon volumeIconDisabled;
    @Resource
    private Icon shuffleIcon;
    @Resource
    private Icon shuffleIconPressed;
    @Resource
    private Icon shuffleIconRollover;
    @Resource
    private Icon shuffleIconActive;
    @Resource
    private Font font;
    private final JXPanel innerPanel;
    private final JButton backButton;
    private final JButton playButton;
    private final JButton pauseButton;
    private final JButton forwardButton;
    private final LimeSliderBar progressSlider;
    private final JPanel statusPanel;
    private final JButton volumeButton;
    private JButton shuffleButton;
    private int numberOfPlayerTimeValuesToIgnore = 0;
    private final JPopupMenu volumeControlPopup;
    private final VolumeSlider volumeSlider;
    private final MarqueeButton titleLabel;
    private static final String BACK = "BACK";
    private static final String PLAY = "PLAY";
    private static final String PAUSE = "PAUSE";
    private static final String FORWARD = "FORWARD";
    private static final String VOLUME = "VOLUME";
    private static final String SHUFFLE = "SHUFFLE";
    private final Provider<PlayerMediator> playerProvider;
    private final LibraryMediator libraryMediator;
    private final CategoryManager categoryManager;
    private SettingListener settingListener;

    public PlayerControlPanel(Provider<PlayerMediator> playerProvider, LibraryMediator libraryMediator, CategoryManager categoryManager, SliderBarDecorator sliderBarDecorator) {
        this.playerProvider = playerProvider;
        this.libraryMediator = libraryMediator;
        this.categoryManager = categoryManager;
        GuiUtils.assignResources(this);
        this.setLayout(new MigLayout("insets 0, filly, alignx center"));
        this.setOpaque(false);
        final ButtonListener playerListener = new ButtonListener();
        this.backButton = new IconButton(this.backIcon, this.backIconRollover, this.backIconPressed);
        this.backButton.addActionListener(playerListener);
        this.backButton.setActionCommand(BACK);
        this.backButton.setDisabledIcon(this.backIconDisabled);
        this.backButton.setToolTipText(I18n.tr("Skip Back"));
        this.backButton.setFocusable(false);
        this.playButton = new IconButton(this.playIcon, this.playIconRollover, this.playIconPressed);
        this.playButton.addActionListener(playerListener);
        this.playButton.setActionCommand(PLAY);
        this.playButton.setDisabledIcon(this.playIconDisabled);
        this.playButton.setToolTipText(I18n.tr("Play"));
        this.playButton.setFocusable(false);
        this.pauseButton = new IconButton(this.pauseIcon, this.pauseIconRollover, this.pauseIconPressed);
        this.pauseButton.addActionListener(playerListener);
        this.pauseButton.setActionCommand(PAUSE);
        this.pauseButton.setVisible(false);
        this.pauseButton.setToolTipText(I18n.tr("Pause"));
        this.pauseButton.setFocusable(false);
        this.pauseButton.setMinimumSize(this.playButton.getMinimumSize());
        this.pauseButton.setPreferredSize(this.playButton.getPreferredSize());
        this.forwardButton = new IconButton(this.forwardIcon, this.forwardIconRollover, this.forwardIconPressed);
        this.forwardButton.addActionListener(playerListener);
        this.forwardButton.setActionCommand(FORWARD);
        this.forwardButton.setDisabledIcon(this.forwardIconDisabled);
        this.forwardButton.setToolTipText(I18n.tr("Skip Forward"));
        this.forwardButton.setFocusable(false);
        this.volumeButton = new IconButton(this.volumeIcon, this.volumeIconRollover, this.volumeIconPressed);
        this.volumeButton.addActionListener(playerListener);
        this.volumeButton.setActionCommand(VOLUME);
        this.volumeButton.setDisabledIcon(this.volumeIconDisabled);
        this.volumeButton.setToolTipText(I18n.tr("Volume"));
        this.volumeButton.setFocusable(false);
        this.volumeSlider = new VolumeSlider(0, 100);
        this.volumeSlider.setValue((int)(SwingUiSettings.PLAYER_VOLUME.getValue() * (float)this.volumeSlider.getMaximum()));
        this.volumeControlPopup = this.volumeSlider.createPopup();
        if (this.isPlaylistSupported()) {
            this.shuffleButton = new IconButton(this.shuffleIcon, this.shuffleIconRollover, this.shuffleIconPressed, this.shuffleIconActive);
            this.shuffleButton.addActionListener(playerListener);
            this.shuffleButton.setActionCommand(SHUFFLE);
            this.shuffleButton.setRolloverSelectedIcon(this.shuffleIconActive);
            this.shuffleButton.setToolTipText(I18n.tr("Shuffle"));
            this.shuffleButton.setFocusable(false);
        }
        this.progressSlider = new LimeSliderBar();
        sliderBarDecorator.decoratePlain(this.progressSlider);
        this.initProgressControl();
        this.statusPanel = new JPanel(new MigLayout());
        this.titleLabel = new MarqueeButton("", 150);
        this.titleLabel.setFont(this.font);
        ResizeUtils.forceSize(this.titleLabel, new Dimension(206, (int)this.font.getMaxCharBounds(new FontRenderContext(null, false, false)).getHeight()));
        this.statusPanel.add(this.titleLabel);
        this.statusPanel.add((Component)this.progressSlider, "dock south");
        this.statusPanel.setOpaque(false);
        int buttonWidth = this.backButton.getPreferredSize().width + this.playButton.getPreferredSize().width + this.forwardButton.getPreferredSize().width;
        Dimension statusSize = new Dimension(buttonWidth, this.statusPanel.getPreferredSize().height);
        this.statusPanel.setPreferredSize(statusSize);
        this.innerPanel = new JXPanel(new MigLayout("insets 4 10 4 10, filly, gapy 5, alignx center"));
        this.innerPanel.setOpaque(false);
        this.innerPanel.setBackgroundPainter(this.createStatusBackgroundPainter());
        if (this.isPlaylistSupported()) {
            this.innerPanel.add((Component)this.backButton, "gapright 1");
        }
        this.innerPanel.add((Component)this.pauseButton, "hidemode 3");
        this.innerPanel.add((Component)this.playButton, "hidemode 3");
        if (this.isPlaylistSupported()) {
            this.innerPanel.add((Component)this.forwardButton, "gapright 3");
        }
        this.innerPanel.add((Component)this.statusPanel, "gapbottom 2, hidemode 2");
        this.innerPanel.add((Component)this.volumeButton, "gapleft 2");
        if (this.isPlaylistSupported()) {
            this.innerPanel.add((Component)this.shuffleButton, "gapleft 2");
        }
        this.innerPanel.setVisible(SwingUiSettings.PLAYER_ENABLED.getValue());
        this.add((Component)this.innerPanel, "gaptop 2, gapbottom 2");
        VolumeController volumeController = new VolumeController();
        this.volumeSlider.addChangeListener(volumeController);
        this.volumeControlPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                playerListener.clearMenu();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                playerListener.clearMenu();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        this.register();
    }

    private void register() {
        this.getPlayerMediator().addMediatorListener(this);
        this.settingListener = new SettingListener(){

            @Override
            public void settingChanged(SettingEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean enabled = SwingUiSettings.PLAYER_ENABLED.getValue();
                        if (!enabled) {
                            PlayerControlPanel.this.getPlayerMediator().stop();
                            PlayerControlPanel.this.resetPlayer();
                        }
                        PlayerControlPanel.this.innerPanel.setVisible(enabled);
                    }
                });
            }
        };
        SwingUiSettings.PLAYER_ENABLED.addSettingListener(this.settingListener);
    }

    private void resetPlayer() {
        if (this.getPlayerMediator().hasScrollingTitle()) {
            this.titleLabel.stop();
        }
        this.progressSlider.setValue(0);
        this.progressSlider.setEnabled(false);
        this.titleLabel.setText("");
        this.titleLabel.setToolTipText("");
    }

    @Override
    public void dispose() {
        this.getPlayerMediator().removeMediatorListener(this);
        SwingUiSettings.PLAYER_ENABLED.removeSettingListener(this.settingListener);
        if (this.getPlayerMediator().hasScrollingTitle()) {
            this.titleLabel.stop();
        }
    }

    private void initProgressControl() {
        this.progressSlider.setUI(new BasicSliderUI(this.progressSlider){

            @Override
            protected Dimension getThumbSize() {
                return new Dimension(5, 8);
            }
        });
        this.progressSlider.addChangeListener(new ProgressListener());
        this.progressSlider.setMaximum(Integer.MAX_VALUE);
        this.progressSlider.setMaximumSize(new Dimension(206, 8));
        this.progressSlider.setMinimumSize(new Dimension(206, 8));
        this.progressSlider.setPreferredSize(new Dimension(206, 8));
        this.progressSlider.setSize(new Dimension(206, 6));
        this.progressSlider.setEnabled(false);
        this.progressSlider.setMinorTickSpacing(1);
        this.progressSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!PlayerControlPanel.this.progressSlider.isEnabled()) {
                    return;
                }
                this.mouseSkip(e.getX());
                PlayerInspectionUtils.playerUsed();
            }

            protected void mouseSkip(int x) {
                if (PlayerControlPanel.this.progressSlider.getUI() instanceof BasicSliderUI) {
                    PlayerControlPanel.this.progressSlider.setValue(((BasicSliderUI)PlayerControlPanel.this.progressSlider.getUI()).valueForXPosition(x));
                    PlayerControlPanel.this.numberOfPlayerTimeValuesToIgnore = 2;
                }
            }
        });
    }

    private Painter<JXPanel> createStatusBackgroundPainter() {
        return new ComponentBackgroundPainter<JXPanel>(this.innerBackground, this.innerBorder, this.bevelLeft, this.bevelTop1, this.bevelTop2, this.bevelRight, this.bevelBottom, this.arcWidth, this.arcHeight, BorderPainter.AccentType.SHADOW);
    }

    private PlayerMediator getPlayerMediator() {
        return this.playerProvider.get();
    }

    @Override
    public void progressUpdated(float progress) {
        if (!this.progressSlider.getValueIsAdjusting() && this.getPlayerMediator().getStatus() != PlayerState.SEEKING) {
            if (this.numberOfPlayerTimeValuesToIgnore > 0) {
                --this.numberOfPlayerTimeValuesToIgnore;
            } else {
                this.progressSlider.setValue((int)((float)this.progressSlider.getMaximum() * progress));
            }
        }
    }

    @Override
    public void songChanged(String name) {
        this.initializeVolumeSettings();
        this.progressSlider.setEnabled(this.getPlayerMediator().isSeekable());
        this.titleLabel.setText(name);
        this.titleLabel.setToolTipText(name);
        if (this.getPlayerMediator().hasScrollingTitle()) {
            this.titleLabel.start();
        }
        if (!this.innerPanel.isVisible()) {
            this.innerPanel.setVisible(true);
        }
    }

    private void initializeVolumeSettings() {
        this.updateVolumeFromSetting();
        this.volumeButton.setEnabled(this.getPlayerMediator().isVolumeSettable());
    }

    @Override
    public void stateChanged(PlayerState playerState) {
        this.progressSlider.setEnabled(this.getPlayerMediator().isSeekable());
        if (playerState == PlayerState.OPENED || playerState == PlayerState.SEEKED) {
            this.initializeVolumeSettings();
        } else if (playerState == PlayerState.GAIN) {
            return;
        }
        if (playerState == PlayerState.PLAYING || playerState == PlayerState.SEEKING_PLAY) {
            this.playButton.setVisible(false);
            this.pauseButton.setVisible(true);
            if (this.getPlayerMediator().hasScrollingTitle()) {
                this.titleLabel.start();
            }
        } else if (playerState == PlayerState.PAUSED || playerState == PlayerState.SEEKING_PAUSED || playerState == PlayerState.EOM || playerState == PlayerState.STOPPED || playerState == PlayerState.UNKNOWN || playerState == PlayerState.NO_SOUND_DEVICE) {
            this.playButton.setVisible(true);
            this.pauseButton.setVisible(false);
            if (this.getPlayerMediator().hasScrollingTitle()) {
                this.titleLabel.stop();
            }
        }
    }

    private boolean isPlaylistSupported() {
        return this.getPlayerMediator().isPlaylistSupported();
    }

    private void setVolume(float volume) {
        SwingUiSettings.PLAYER_VOLUME.setValue(volume);
        this.updateVolumeFromSetting();
    }

    private void updateVolumeFromSetting() {
        if (this.getPlayerMediator().isVolumeSettable()) {
            this.getPlayerMediator().setVolume(SwingUiSettings.PLAYER_VOLUME.getValue());
        }
    }

    private class VolumeController
    implements ChangeListener {
        private VolumeController() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            PlayerInspectionUtils.playerUsed();
            PlayerControlPanel.this.setVolume((float)PlayerControlPanel.this.volumeSlider.getValue() / (float)PlayerControlPanel.this.volumeSlider.getMaximum());
        }
    }

    private class ProgressListener
    implements ChangeListener {
        private boolean waiting = false;

        private ProgressListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (PlayerControlPanel.this.progressSlider.getMaximum() != 0 && PlayerControlPanel.this.getPlayerMediator().isSeekable() && PlayerControlPanel.this.progressSlider.getValueIsAdjusting()) {
                if (!this.waiting) {
                    this.waiting = true;
                }
            } else if (this.waiting) {
                this.waiting = false;
                double percent = (double)PlayerControlPanel.this.progressSlider.getValue() / (double)PlayerControlPanel.this.progressSlider.getMaximum();
                PlayerControlPanel.this.getPlayerMediator().skip(percent);
                PlayerControlPanel.this.progressSlider.setValue((int)(percent * (double)PlayerControlPanel.this.progressSlider.getMaximum()));
            }
        }
    }

    private class ButtonListener
    implements ActionListener {
        private long menuInvizTime = -1L;

        private ButtonListener() {
        }

        public void clearMenu() {
            this.menuInvizTime = System.currentTimeMillis();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlayerInspectionUtils.playerUsed();
            if (e.getActionCommand() == PlayerControlPanel.PLAY) {
                if (PlayerControlPanel.this.getPlayerMediator().getCurrentMediaFile() != null) {
                    PlayerControlPanel.this.getPlayerMediator().resume();
                } else {
                    List<LocalFileItem> selectedItems = PlayerControlPanel.this.libraryMediator.getSelectedItems();
                    if (selectedItems.size() > 0) {
                        PlayerUtils.playOrLaunch(selectedItems.get(0).getFile(), PlayerControlPanel.this.categoryManager);
                    }
                }
            } else if (e.getActionCommand() == PlayerControlPanel.PAUSE) {
                PlayerControlPanel.this.getPlayerMediator().pause();
            } else if (e.getActionCommand() == PlayerControlPanel.FORWARD) {
                PlayerControlPanel.this.getPlayerMediator().nextSong();
            } else if (e.getActionCommand() == PlayerControlPanel.BACK) {
                PlayerControlPanel.this.getPlayerMediator().prevSong();
            } else if (e.getActionCommand() == PlayerControlPanel.VOLUME) {
                if ((float)(System.currentTimeMillis() - this.menuInvizTime) > 250.0f) {
                    PlayerControlPanel.this.volumeControlPopup.show(PlayerControlPanel.this.volumeButton, 0, 14);
                    PlayerControlPanel.this.volumeControlPopup.requestFocus();
                }
            } else if (e.getActionCommand() == PlayerControlPanel.SHUFFLE) {
                PlayerControlPanel.this.getPlayerMediator().setShuffle(!PlayerControlPanel.this.getPlayerMediator().isShuffle());
                PlayerControlPanel.this.shuffleButton.setSelected(PlayerControlPanel.this.getPlayerMediator().isShuffle());
                PlayerControlPanel.this.shuffleButton.setPressedIcon(PlayerControlPanel.this.getPlayerMediator().isShuffle() ? PlayerControlPanel.this.shuffleIconActive : PlayerControlPanel.this.shuffleIconPressed);
            }
        }
    }
}

