/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.player;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.components.LimeJFrame;
import org.limewire.ui.swing.mainframe.GlobalLayeredPane;
import org.limewire.ui.swing.nav.NavCategory;
import org.limewire.ui.swing.nav.NavItem;
import org.limewire.ui.swing.nav.NavMediator;
import org.limewire.ui.swing.nav.NavSelectable;
import org.limewire.ui.swing.nav.NavigationListener;
import org.limewire.ui.swing.nav.Navigator;
import org.limewire.ui.swing.player.VideoPanel;
import org.limewire.ui.swing.player.VideoPanelFactory;
import org.limewire.ui.swing.player.VideoPlayerMediator;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.util.OSUtils;

class VideoDisplayDirector {
    private final JLayeredPane limeWireLayeredPane;
    private final Integer videoLayer = new Integer(JLayeredPane.DEFAULT_LAYER + 1);
    private VideoPanel videoPanel;
    private JFrame fullScreenFrame;
    private NavigationListener closeVideoOnNavigation;
    @Resource(key="WireframeTop.preferredSize")
    private Dimension topPanelPreferredSize;
    private final VideoPanelFactory videoPanelFactory;
    private final Navigator navigator;
    private final Provider<VideoPlayerMediator> videoPlayerMediator;
    private VideoPanelResizer resizerListener;

    @Inject
    public VideoDisplayDirector(@GlobalLayeredPane JLayeredPane limeWireLayeredPane, Provider<VideoPlayerMediator> videoPlayerMediator, VideoPanelFactory videoPanelFactory, Navigator navigator) {
        this.limeWireLayeredPane = limeWireLayeredPane;
        this.videoPlayerMediator = videoPlayerMediator;
        this.videoPanelFactory = videoPanelFactory;
        this.navigator = navigator;
        GuiUtils.assignResources(this);
        assert (this.topPanelPreferredSize != null);
        this.resizerListener = new VideoPanelResizer();
    }

    public void initialize(Container videoRenderer, boolean isFullScreen) {
        boolean isReinitializing = false;
        if (this.videoPanel != null) {
            isReinitializing = true;
            this.close();
        }
        this.videoPanel = this.videoPanelFactory.createVideoPanel(videoRenderer);
        NavItem selectedNavItem = this.navigator.getSelectedNavItem();
        if (selectedNavItem == null || selectedNavItem.getId().equals("Home")) {
            NavItem item = this.navigator.getNavItem(NavCategory.LIBRARY, "Library");
            item.select();
        }
        if (isFullScreen) {
            this.initializeFullScreen();
        } else {
            this.initializeInClient(isReinitializing);
        }
    }

    private void initializeInClient(boolean isReinitializing) {
        this.limeWireLayeredPane.add((Component)this.videoPanel.getComponent(), this.videoLayer);
        this.registerNavigationListener();
        this.limeWireLayeredPane.addComponentListener(this.resizerListener);
        if (isReinitializing) {
            this.showInClient();
        } else {
            this.videoPanel.getComponent().setVisible(false);
        }
    }

    private void registerNavigationListener() {
        if (this.closeVideoOnNavigation == null) {
            this.closeVideoOnNavigation = new CloseVideoOnNavigationListener();
        }
        this.navigator.addNavigationListener(this.closeVideoOnNavigation);
    }

    private void initializeFullScreen() {
        GuiUtils.getMainFrame().setVisible(false);
        this.fullScreenFrame = new LimeJFrame();
        this.fullScreenFrame.setTitle(GuiUtils.getMainFrame().getTitle());
        this.fullScreenFrame.setUndecorated(true);
        this.fullScreenFrame.add((Component)this.videoPanel.getComponent(), "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.fullScreenFrame.setBounds(0, 0, screenSize.width, screenSize.height);
        this.fullScreenFrame.addNotify();
    }

    public void show() {
        if (this.isFullScreen()) {
            this.showFullScreen();
        } else {
            this.showInClient();
        }
        this.videoPanel.playerLoaded();
    }

    private void showInClient() {
        this.videoPanel.getComponent().setVisible(true);
        this.resizeVideoContainer();
        GuiUtils.getMainFrame().toFront();
        this.videoPanel.requestFocus();
    }

    private void showFullScreen() {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = environment.getDefaultScreenDevice();
        if (OSUtils.isMacOSX() && device.isFullScreenSupported()) {
            device.setFullScreenWindow(this.fullScreenFrame);
        } else {
            this.fullScreenFrame.setVisible(true);
            this.fullScreenFrame.toFront();
        }
    }

    public boolean isFullScreen() {
        return this.fullScreenFrame != null;
    }

    public void close() {
        if (this.isFullScreen()) {
            this.closeFullScreen();
        } else {
            this.closeInClient();
        }
        this.videoPanel.dispose();
        this.videoPanel = null;
        GuiUtils.getMainFrame().repaint();
    }

    private void closeFullScreen() {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = environment.getDefaultScreenDevice();
        if (OSUtils.isMacOSX() && device.isFullScreenSupported()) {
            device.setFullScreenWindow(null);
        }
        this.fullScreenFrame.setVisible(false);
        this.fullScreenFrame.dispose();
        this.fullScreenFrame = null;
        GuiUtils.getMainFrame().setVisible(true);
    }

    private void closeInClient() {
        this.limeWireLayeredPane.removeComponentListener(this.resizerListener);
        this.limeWireLayeredPane.remove(this.videoPanel.getComponent());
        this.removeNavigationListener();
    }

    private void removeNavigationListener() {
        this.navigator.removeNavigationListener(this.closeVideoOnNavigation);
    }

    private void resizeVideoContainer() {
        if (this.videoPanel != null) {
            Rectangle parentBounds = this.videoPanel.getComponent().getParent().getBounds();
            this.videoPanel.getComponent().setBounds(0, (int)this.topPanelPreferredSize.getHeight(), (int)parentBounds.getWidth(), (int)parentBounds.getHeight() - (int)this.topPanelPreferredSize.getHeight());
            this.videoPanel.getComponent().revalidate();
        }
    }

    private class CloseVideoOnNavigationListener
    implements NavigationListener {
        private CloseVideoOnNavigationListener() {
        }

        @Override
        public void itemSelected(NavCategory category, NavItem navItem, NavSelectable selectable, NavMediator navMediator) {
            ((VideoPlayerMediator)VideoDisplayDirector.this.videoPlayerMediator.get()).closeVideo();
        }

        @Override
        public void categoryAdded(NavCategory category) {
        }

        @Override
        public void categoryRemoved(NavCategory category, boolean wasSelected) {
        }

        @Override
        public void itemAdded(NavCategory category, NavItem navItem) {
        }

        @Override
        public void itemRemoved(NavCategory category, NavItem navItem, boolean wasSelected) {
        }
    }

    private class VideoPanelResizer
    extends ComponentAdapter {
        private VideoPanelResizer() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            VideoDisplayDirector.this.resizeVideoContainer();
        }
    }
}

