/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.Painter;
import org.limewire.core.api.search.SearchDetails;
import org.limewire.core.api.search.browse.BrowseStatus;
import org.limewire.friend.api.Friend;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.components.LimePopupDialog;
import org.limewire.ui.swing.friends.refresh.AllFriendsRefreshManager;
import org.limewire.ui.swing.friends.refresh.BrowseRefreshStatus;
import org.limewire.ui.swing.friends.refresh.BrowseRefreshStatusListener;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.painter.ComponentBackgroundPainter;
import org.limewire.ui.swing.search.DefaultSearchRepeater;
import org.limewire.ui.swing.search.model.SearchResultsModel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class BrowseStatusPanel
extends JXPanel
implements Disposable {
    private BrowseStatus status;
    private JButton warningButton;
    private JXPanel refreshPanel;
    private JButton refreshButton;
    private JLabel updatesLabel;
    @Resource
    private Icon warningIcon;
    @Resource
    private int arcWidth;
    @Resource
    private int arcHeight;
    @Resource
    private Color innerBorder;
    @Resource
    private Color innerBackground;
    @Resource
    private Color bevelLeft;
    @Resource
    private Color bevelTop1;
    @Resource
    private Color bevelTop2;
    @Resource
    private Color bevelRight;
    @Resource
    private Color bevelBottom;
    @Resource
    private Font font;
    @Resource
    private Color foreground;
    @Resource
    private Color headerForeground;
    @Resource
    private Font headerFont;
    private final SearchResultsModel searchResultsModel;
    private final AllFriendsRefreshManager allFriendsRefreshManager;
    private BrowseRefreshStatusListener browseRefreshStatusListener;

    public BrowseStatusPanel(SearchResultsModel searchResultsModel, AllFriendsRefreshManager allFriendsRefreshManager) {
        GuiUtils.assignResources(this);
        this.searchResultsModel = searchResultsModel;
        this.allFriendsRefreshManager = allFriendsRefreshManager;
        this.setOpaque(false);
        this.initializeComponents();
        if (this.isAllFriendsBrowse()) {
            this.initializeAllFriendsListener();
        }
        this.layoutComponents();
        this.update();
    }

    private void initializeAllFriendsListener() {
        this.browseRefreshStatusListener = new BrowseRefreshStatusListener(){

            @Override
            public void statusChanged(final BrowseRefreshStatus status) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BrowseStatusPanel.this.refreshPanel.setVisible(status != BrowseRefreshStatus.REFRESHED);
                    }
                });
            }
        };
        this.allFriendsRefreshManager.addBrowseRefreshStatusListener(this.browseRefreshStatusListener);
    }

    private void initializeComponents() {
        this.warningButton = new IconButton(this.warningIcon);
        this.warningButton.addActionListener(new WarningAction());
        this.warningButton.setVisible(false);
        this.refreshPanel = new JXPanel();
        this.refreshPanel.setOpaque(false);
        this.refreshPanel.setBackgroundPainter(this.createRefreshBackgroundPainter());
        this.refreshPanel.setVisible(false);
        this.updatesLabel = new JLabel(I18n.tr("There are updates!"));
        this.updatesLabel.setFont(this.font);
        this.updatesLabel.setForeground(this.foreground);
        this.refreshButton = new HyperlinkButton(new RefreshAction());
        this.refreshButton.setFont(this.font);
    }

    private void layoutComponents() {
        this.refreshPanel.setLayout(new MigLayout("insets 6 8 6 8, gap 0, novisualpadding, aligny 50%, fill"));
        this.refreshPanel.add(this.updatesLabel);
        this.refreshPanel.add((Component)this.refreshButton, "gapleft 3");
        this.setLayout(new MigLayout("insets 0, gap 0, novisualpadding, filly"));
        this.add(this.warningButton);
        this.add(this.refreshPanel);
    }

    public void setBrowseStatus(BrowseStatus status) {
        this.status = status;
        this.update();
    }

    private void update() {
        if (!this.isAllFriendsBrowse()) {
            this.warningButton.setVisible(this.status != null && this.status.getState() == BrowseStatus.BrowseState.PARTIAL_FAIL);
            this.refreshPanel.setVisible(this.status != null && this.status.getState() == BrowseStatus.BrowseState.UPDATED);
        }
    }

    private void showFailedBrowses() {
        ArrayList<String> friends = new ArrayList<String>();
        ArrayList<String> p2pUsers = new ArrayList<String>();
        for (Friend person : this.status.getFailedFriends()) {
            if (person.isAnonymous()) {
                p2pUsers.add(person.getRenderName());
                continue;
            }
            friends.add(person.getRenderName());
        }
        JXPanel centerPanel = new JXPanel(new MigLayout("insets 0 5 5 5, gap 0, novisualpadding, fill"));
        if (friends.size() > 0) {
            centerPanel.add((Component)this.createHeaderLabel(I18n.tr("Friends")), "gaptop 5, wrap");
        }
        for (String name : friends) {
            centerPanel.add((Component)this.createItemLabel(name), "wrap");
        }
        if (p2pUsers.size() > 0) {
            centerPanel.add((Component)this.createHeaderLabel(I18n.tr("P2P Users")), "gaptop 5, wrap");
        }
        for (String name : p2pUsers) {
            centerPanel.add((Component)this.createItemLabel(name), "wrap");
        }
        LimePopupDialog popup = new LimePopupDialog(I18n.tr("Unable to Browse"), centerPanel);
        popup.showPopup(this.warningButton, 0, 0);
    }

    private JLabel createHeaderLabel(String text) {
        JLabel header = new JLabel(text);
        header.setForeground(this.headerForeground);
        header.setFont(this.headerFont);
        return header;
    }

    private JLabel createItemLabel(String text) {
        JLabel item = new JLabel(text);
        item.setForeground(this.foreground);
        item.setFont(this.font);
        return item;
    }

    private Painter<JXPanel> createRefreshBackgroundPainter() {
        return new ComponentBackgroundPainter<JXPanel>(this.innerBackground, this.innerBorder, this.bevelLeft, this.bevelTop1, this.bevelTop2, this.bevelRight, this.bevelBottom, this.arcWidth, this.arcHeight, BorderPainter.AccentType.NONE);
    }

    private boolean isAllFriendsBrowse() {
        return this.searchResultsModel.getSearchType() == SearchDetails.SearchType.ALL_FRIENDS_BROWSE;
    }

    @Override
    public void dispose() {
        if (this.browseRefreshStatusListener != null) {
            this.allFriendsRefreshManager.removeBrowseRefreshStatusListener(this.browseRefreshStatusListener);
            this.browseRefreshStatusListener = null;
        }
    }

    private class WarningAction
    extends AbstractAction {
        private WarningAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BrowseStatusPanel.this.showFailedBrowses();
        }
    }

    private class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            super(I18n.tr("Refresh"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BrowseStatusPanel.this.isAllFriendsBrowse()) {
                BrowseStatusPanel.this.allFriendsRefreshManager.refresh();
            } else {
                new DefaultSearchRepeater(BrowseStatusPanel.this.status.getBrowseSearch(), BrowseStatusPanel.this.searchResultsModel).refresh();
            }
        }
    }
}

