/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.components.ColoredBusyLabel;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.ResizeUtils;
import org.limewire.ui.swing.util.SwingUtils;

class SearchResultsMessagePanel
extends JXPanel
implements SettingListener {
    private ClassicSearchResultsHintPanel classicSearchResultsHintPanel;
    private MessagePanel messagePanel;
    private JPanel currentPanel = null;
    @Resource
    private int height;
    @Resource
    private Color background;
    @Resource
    private Font switchFont;
    @Resource
    private Color switchColor;
    @Resource
    private Font closeFont;
    @Resource
    private Icon switchArrowIcon;
    @Resource
    private Icon closeIcon;
    @Resource
    private Icon closeDownIcon;
    @Resource
    private Icon closeHoverIcon;

    public SearchResultsMessagePanel() {
        GuiUtils.assignResources(this);
        SwingUiSettings.SHOW_CLASSIC_REMINDER.addSettingListener(this);
        this.setLayout(new BorderLayout());
    }

    public void setMessageType(MessageType messageType) {
        switch (messageType) {
            case CONNECTING_TO_ULTRAPEERS: {
                this.getMessagePanel().setMessage(I18n.tr("You might not receive many results until LimeWire is fully connected"));
                this.installPanel(this.getMessagePanel());
                break;
            }
            case CLASSIC_SEARCH_RESULTS_HINT: {
                this.installPanel(this.getClassicSearchResultsHintPanel());
                break;
            }
            case NONE: {
                this.installPanel(null);
                break;
            }
            default: {
                throw new IllegalStateException("invalid type: " + (Object)((Object)messageType));
            }
        }
    }

    private void installPanel(JPanel panel) {
        if (this.currentPanel != panel) {
            this.removeAll();
            if (panel != null) {
                this.add(panel);
            }
            this.currentPanel = panel;
        }
        this.setVisible(this.currentPanel != null);
    }

    void dispose() {
        SwingUiSettings.SHOW_CLASSIC_REMINDER.removeSettingListener(this);
    }

    public boolean isShowClassicSearchResultsHint() {
        return SwingUiSettings.SHOW_CLASSIC_REMINDER.getValue();
    }

    @Override
    public void settingChanged(SettingEvent evt) {
        SwingUtils.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                if (SwingUiSettings.SHOW_CLASSIC_REMINDER.getValue()) {
                    SearchResultsMessagePanel.this.installPanel(SearchResultsMessagePanel.this.getClassicSearchResultsHintPanel());
                }
                SearchResultsMessagePanel.this.setVisible(SwingUiSettings.SHOW_CLASSIC_REMINDER.getValue());
            }
        });
    }

    private ClassicSearchResultsHintPanel getClassicSearchResultsHintPanel() {
        if (this.classicSearchResultsHintPanel == null) {
            this.classicSearchResultsHintPanel = new ClassicSearchResultsHintPanel();
        }
        return this.classicSearchResultsHintPanel;
    }

    private MessagePanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messagePanel = new MessagePanel();
        }
        return this.messagePanel;
    }

    private class MessagePanel
    extends JPanel {
        private JLabel messageLabel;

        public MessagePanel() {
            super(new MigLayout("insets 0, gap 0, fill, aligny center"));
            ResizeUtils.forceHeight(this, SearchResultsMessagePanel.this.height);
            this.setBackground(SearchResultsMessagePanel.this.background);
            this.add(Box.createHorizontalGlue(), "gapbefore 4, alignx center, push");
            this.messageLabel = new JLabel("");
            this.messageLabel.setFont(SearchResultsMessagePanel.this.switchFont);
            this.messageLabel.setForeground(SearchResultsMessagePanel.this.switchColor);
            this.add((Component)this.messageLabel, "gapbefore 4, aligny center, alignx right");
            ColoredBusyLabel busyLabel = new ColoredBusyLabel(new Dimension(20, 20));
            busyLabel.setBusy(true);
            this.add((Component)busyLabel, "gapbefore 25, gapright 25, alignx right");
        }

        void setMessage(String message) {
            this.messageLabel.setText(message);
        }
    }

    private class ClassicSearchResultsHintPanel
    extends JPanel {
        public ClassicSearchResultsHintPanel() {
            super(new MigLayout("insets 0, gap 0, fill, aligny center"));
            ResizeUtils.forceHeight(this, SearchResultsMessagePanel.this.height);
            this.setBackground(SearchResultsMessagePanel.this.background);
            IconButton close = new IconButton(new AbstractAction(I18n.tr("close"), SearchResultsMessagePanel.this.closeIcon){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUiSettings.SHOW_CLASSIC_REMINDER.setValue(false);
                    SearchResultsMessagePanel.this.setVisible(false);
                }
            });
            close.setPressedIcon(SearchResultsMessagePanel.this.closeDownIcon);
            close.setRolloverIcon(SearchResultsMessagePanel.this.closeHoverIcon);
            close.setFont(SearchResultsMessagePanel.this.closeFont);
            this.add((Component)close, "gapleft 8, push");
            JLabel hintLabel = new JLabel(I18n.tr("Switch to Classic View"));
            hintLabel.setFont(SearchResultsMessagePanel.this.switchFont);
            hintLabel.setForeground(SearchResultsMessagePanel.this.switchColor);
            this.add((Component)hintLabel, "gapbefore 4, alignx right");
            this.add((Component)new JLabel(SearchResultsMessagePanel.this.switchArrowIcon), "gapbefore 4, gapright 25, alignx right");
        }
    }

    public static enum MessageType {
        NONE,
        CONNECTING_TO_ULTRAPEERS,
        CLASSIC_SEARCH_RESULTS_HINT;

    }
}

