/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.core.api.search.browse.BrowseStatus;
import org.limewire.core.api.search.sponsored.SponsoredResult;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.HeaderBar;
import org.limewire.ui.swing.components.decorators.HeaderBarDecorator;
import org.limewire.ui.swing.filter.AdvancedFilterPanel;
import org.limewire.ui.swing.filter.AdvancedFilterPanelFactory;
import org.limewire.ui.swing.friends.refresh.AllFriendsRefreshManager;
import org.limewire.ui.swing.search.AwaitingConnectionsPanel;
import org.limewire.ui.swing.search.BrowseFailedMessagePanel;
import org.limewire.ui.swing.search.BrowseFailedMessagePanelFactory;
import org.limewire.ui.swing.search.BrowseStatusPanel;
import org.limewire.ui.swing.search.ResultsContainer;
import org.limewire.ui.swing.search.ResultsContainerFactory;
import org.limewire.ui.swing.search.SearchResultsMessagePanel;
import org.limewire.ui.swing.search.SearchViewType;
import org.limewire.ui.swing.search.SortAndFilterPanel;
import org.limewire.ui.swing.search.SortAndFilterPanelFactory;
import org.limewire.ui.swing.search.SponsoredResultsPanel;
import org.limewire.ui.swing.search.SponsoredResultsView;
import org.limewire.ui.swing.search.model.SearchResultsModel;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.BaseResultPanel;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.table.TableCellHeaderRenderer;
import org.limewire.ui.swing.util.CategoryIconManager;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class SearchResultsPanel
extends JXPanel
implements SponsoredResultsView,
Disposable {
    private final HeaderBarDecorator headerBarDecorator;
    private final CategoryIconManager categoryIconManager;
    private final JLabel searchTitleLabel = new JLabel();
    private final AdvancedFilterPanel<VisualSearchResult> filterPanel;
    private final ResultsContainer resultsContainer;
    private final SortAndFilterPanel sortAndFilterPanel;
    private final SponsoredResultsPanel sponsoredResultsPanel;
    private JScrollPane scrollPane;
    private ScrollablePanel scrollablePanel;
    private final SearchResultsMessagePanel messagePanel;
    private Component messagePanelsGap;
    private final SettingListener viewTypeListener;
    private final ListEventListener<VisualSearchResult> resultCountListener;
    private final SearchResultsModel searchResultsModel;
    @Resource
    private Color tabHighlightTopGradientColor;
    @Resource
    private Color tabHighlightBottomGradientColor;
    private boolean lifeCycleComplete = true;
    private boolean fullyConnected = true;
    private boolean receivedSponsoredResults = false;
    private boolean receivedSearchResults = false;
    private BrowseStatus browseStatus = null;
    private BrowseStatusPanel browseStatusPanel;
    private String browseTitle;
    private final BrowseFailedMessagePanel browseFailedPanel;
    private final JXLayer jxlayer;
    private OverlayType overlayType = OverlayType.NONE;
    private SettingListener messagePanelGapHider;

    @Inject
    public SearchResultsPanel(@Assisted SearchResultsModel searchResultsModel, ResultsContainerFactory containerFactory, SortAndFilterPanelFactory sortAndFilterFactory, AdvancedFilterPanelFactory<VisualSearchResult> filterPanelFactory, SponsoredResultsPanel sponsoredResultsPanel, HeaderBarDecorator headerBarDecorator, CategoryIconManager categoryIconManager, BrowseFailedMessagePanelFactory browseFailedMessagePanelFactory, AllFriendsRefreshManager allFriendsRefreshManager) {
        super(new BorderLayout());
        GuiUtils.assignResources(this);
        this.searchResultsModel = searchResultsModel;
        this.headerBarDecorator = headerBarDecorator;
        this.categoryIconManager = categoryIconManager;
        this.sponsoredResultsPanel = sponsoredResultsPanel;
        this.sponsoredResultsPanel.setVisible(false);
        this.browseFailedPanel = browseFailedMessagePanelFactory.create(searchResultsModel);
        this.sortAndFilterPanel = sortAndFilterFactory.create(searchResultsModel);
        this.filterPanel = filterPanelFactory.create(searchResultsModel, searchResultsModel.getSearchType());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollablePanel = new ScrollablePanel();
        this.configureEnclosingScrollPane();
        this.resultsContainer = containerFactory.create(searchResultsModel);
        this.viewTypeListener = new SettingListener(){
            int oldSearchViewTypeId = SwingUiSettings.SEARCH_VIEW_TYPE_ID.getValue();

            @Override
            public void settingChanged(SettingEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int newSearchViewTypeId = SwingUiSettings.SEARCH_VIEW_TYPE_ID.getValue();
                        if (newSearchViewTypeId != oldSearchViewTypeId) {
                            SearchViewType newSearchViewType = SearchViewType.forId(newSearchViewTypeId);
                            SearchResultsPanel.this.resultsContainer.setViewType(newSearchViewType);
                            SearchResultsPanel.this.syncScrollPieces();
                            oldSearchViewTypeId = newSearchViewTypeId;
                        }
                    }
                });
            }
        };
        SwingUiSettings.SEARCH_VIEW_TYPE_ID.addSettingListener(this.viewTypeListener);
        this.updateTitle();
        this.resultCountListener = new ListEventListener<VisualSearchResult>(){

            @Override
            public void listChanged(ListEvent<VisualSearchResult> listChanges) {
                SearchResultsPanel.this.updateTitle();
                SearchResultsPanel.this.receivedSearchResults = SearchResultsPanel.this.searchResultsModel.getUnfilteredList().size() > 0;
                SearchResultsPanel.this.updateMessages();
            }
        };
        searchResultsModel.getUnfilteredList().addListEventListener(this.resultCountListener);
        searchResultsModel.getFilteredList().addListEventListener(this.resultCountListener);
        this.sortAndFilterPanel.setSearchCategory(searchResultsModel.getSearchCategory());
        this.resultsContainer.showCategory(searchResultsModel.getSearchCategory());
        this.syncScrollPieces();
        this.filterPanel.setSearchCategory(searchResultsModel.getSearchCategory());
        this.filterPanel.addCategoryListener(new AdvancedFilterPanel.CategoryListener(){

            @Override
            public void categorySelected(SearchCategory displayCategory) {
                SearchResultsPanel.this.sortAndFilterPanel.setSearchCategory(displayCategory);
                SearchResultsPanel.this.resultsContainer.showCategory(displayCategory);
                SearchResultsPanel.this.syncScrollPieces();
                SearchResultsPanel.this.updateTitle();
            }
        });
        this.browseStatusPanel = new BrowseStatusPanel(searchResultsModel, allFriendsRefreshManager);
        this.messagePanel = new SearchResultsMessagePanel();
        if (this.messagePanel.isShowClassicSearchResultsHint()) {
            this.messagePanelGapHider = new SettingListener(){

                @Override
                public void settingChanged(SettingEvent evt) {
                    if (!SwingUiSettings.SHOW_CLASSIC_REMINDER.getValue()) {
                        SearchResultsPanel.this.messagePanelsGap.setVisible(false);
                    }
                }
            };
            SwingUiSettings.SHOW_CLASSIC_REMINDER.addSettingListener(this.messagePanelGapHider);
        }
        this.jxlayer = new JXLayer<JPanel>(this.createSearchResultsPanel());
        this.jxlayer.getGlassPane().setLayout(new BorderLayout());
        this.add((Component)this.jxlayer, "Center");
    }

    void setOverlayType(OverlayType overlayType) {
        if (this.overlayType != overlayType) {
            this.overlayType = overlayType;
            switch (overlayType) {
                case AWAITING_CONNECTIONS: {
                    this.installOverlay(new AwaitingConnectionsPanel(this.headerBarDecorator));
                    break;
                }
                case NO_FRIENDS_ON_LIMEWIRE: {
                    this.installOverlay(this.browseFailedPanel);
                    break;
                }
                case NONE: {
                    this.uninstallOverlay();
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid type: " + (Object)((Object)overlayType));
                }
            }
        }
    }

    private void installOverlay(JComponent component) {
        this.jxlayer.getGlassPane().setVisible(false);
        this.jxlayer.getGlassPane().removeAll();
        this.jxlayer.getGlassPane().add(component);
        this.jxlayer.getGlassPane().setVisible(true);
    }

    private void uninstallOverlay() {
        this.jxlayer.getGlassPane().setVisible(false);
        this.jxlayer.getGlassPane().removeAll();
    }

    @Override
    public void dispose() {
        SwingUiSettings.SEARCH_VIEW_TYPE_ID.removeSettingListener(this.viewTypeListener);
        if (this.messagePanelGapHider != null) {
            SwingUiSettings.SHOW_CLASSIC_REMINDER.removeSettingListener(this.messagePanelGapHider);
        }
        this.searchResultsModel.getFilteredList().removeListEventListener(this.resultCountListener);
        this.searchResultsModel.getUnfilteredList().removeListEventListener(this.resultCountListener);
        this.sortAndFilterPanel.dispose();
        this.filterPanel.dispose();
        this.messagePanel.dispose();
        this.browseFailedPanel.dispose();
        this.searchResultsModel.dispose();
        this.browseStatusPanel.dispose();
    }

    public SearchResultsModel getModel() {
        return this.searchResultsModel;
    }

    protected void configureEnclosingScrollPane() {
        JTableHeader th = new JTableHeader();
        th.setDefaultRenderer(new TableCellHeaderRenderer());
        Component renderer = th.getDefaultRenderer().getTableCellRendererComponent(null, "", false, false, -1, -1);
        JPanel cornerComponent = new JPanel(new BorderLayout());
        cornerComponent.add(renderer, "Center");
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", cornerComponent);
    }

    @Override
    public void addSponsoredResults(List<SponsoredResult> sponsoredResults) {
        for (SponsoredResult result : sponsoredResults) {
            this.sponsoredResultsPanel.addEntry(result);
        }
        if (!this.sponsoredResultsPanel.isVisible()) {
            this.sponsoredResultsPanel.setVisible(true);
            this.syncColumnHeader();
        }
        this.receivedSponsoredResults = true;
        this.updateMessages();
    }

    public void setBrowseTitle(String title) {
        this.browseTitle = title;
        this.updateTitle();
    }

    private void updateTitle() {
        int total = this.searchResultsModel.getUnfilteredList().size();
        int actual = this.searchResultsModel.getFilteredList().size();
        if (this.browseTitle != null) {
            this.searchTitleLabel.setText(actual == total ? I18n.tr("Browse {0} ({1})", this.browseTitle, total) : I18n.tr("Browse {0} - Showing {1} of {2}", this.browseTitle, actual, total));
        } else {
            SearchCategory displayCategory = this.searchResultsModel.getSelectedCategory();
            String title = this.searchResultsModel.getSearchTitle();
            Icon icon = displayCategory == SearchCategory.ALL ? null : this.categoryIconManager.getIcon(displayCategory.getCategory());
            this.searchTitleLabel.setIcon(icon);
            switch (displayCategory) {
                case ALL: {
                    this.searchTitleLabel.setText(actual == total ? I18n.tr("All results for {0} ({1})", title, total) : I18n.tr("All results for {0} - Showing {1} of {2}", title, actual, total));
                    break;
                }
                case AUDIO: {
                    this.searchTitleLabel.setText(actual == total ? I18n.tr("Audio results for {0} ({1})", title, total) : I18n.tr("Audio results for {0} - Showing {1} of {2}", title, actual, total));
                    break;
                }
                case VIDEO: {
                    this.searchTitleLabel.setText(actual == total ? I18n.tr("Video results for {0} ({1})", title, total) : I18n.tr("Video results for {0} - Showing {1} of {2}", title, actual, total));
                    break;
                }
                case IMAGE: {
                    this.searchTitleLabel.setText(actual == total ? I18n.tr("Image results for {0} ({1})", title, total) : I18n.tr("Image results for {0} - Showing {1} of {2}", title, actual, total));
                    break;
                }
                case DOCUMENT: {
                    this.searchTitleLabel.setText(actual == total ? I18n.tr("Document results for {0} ({1})", title, total) : I18n.tr("Document results for {0} - Showing {1} of {2}", title, actual, total));
                    break;
                }
                case PROGRAM: {
                    this.searchTitleLabel.setText(actual == total ? I18n.tr("Program results for {0} ({1})", title, total) : I18n.tr("Program results for {0} - Showing {1} of {2}", title, actual, total));
                    break;
                }
                case OTHER: {
                    this.searchTitleLabel.setText(actual == total ? I18n.tr("Other results for {0} ({1})", title, total) : I18n.tr("Other results for {0} - Showing {1} of {2}", title, actual, total));
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid search category " + (Object)((Object)displayCategory));
                }
            }
        }
    }

    private void syncColumnHeader() {
        Component resultHeader = this.resultsContainer.getScrollPaneHeader();
        if (resultHeader == null) {
            this.scrollPane.setColumnHeaderView(null);
        } else if (!this.sponsoredResultsPanel.isVisible()) {
            this.scrollPane.setColumnHeaderView(resultHeader);
        } else {
            JXPanel headerPanel = new JXPanel();
            headerPanel.setLayout(new MigLayout("hidemode 3, gap 0, insets 0", "[]", "[grow][]"));
            headerPanel.add(resultHeader, "grow, push, alignx left, aligny top");
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            TableColumn column = new TableColumn();
            model.addColumn(column);
            JTableHeader header = new JTableHeader(model);
            header.setDefaultRenderer(new TableCellHeaderRenderer());
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            header.setTable(new JXTable(0, 1));
            int width = this.sponsoredResultsPanel.getPreferredSize().width;
            int height = resultHeader.getPreferredSize().height;
            column.setWidth(width);
            Dimension dimension = new Dimension(width, height);
            header.setPreferredSize(dimension);
            header.setMaximumSize(dimension);
            header.setMinimumSize(dimension);
            headerPanel.add((Component)header, "aligny top, alignx right");
            this.scrollPane.setColumnHeaderView(headerPanel);
        }
        this.scrollPane.validate();
        if (resultHeader instanceof JTableHeader) {
            ((JTableHeader)resultHeader).resizeAndRepaint();
        }
    }

    private JPanel createSearchResultsPanel() {
        JPanel searchResultsComponentsPanel = new JPanel(new MigLayout("hidemode 2, insets 0 0 0 0, gap 0!, novisualpadding", "[][grow]", "[][][][grow]"));
        searchResultsComponentsPanel.setMinimumSize(new Dimension(searchResultsComponentsPanel.getPreferredSize().width, 33));
        RectanglePainter tabHighlight = new RectanglePainter();
        tabHighlight.setFillPaint(new GradientPaint(20.0f, 0.0f, this.tabHighlightTopGradientColor, 20.0f, 33.0f, this.tabHighlightBottomGradientColor));
        tabHighlight.setInsets(new Insets(0, 0, 1, 0));
        tabHighlight.setBorderPaint(null);
        HeaderBar header = new HeaderBar(this.searchTitleLabel);
        header.setLayout(new MigLayout("insets 0, gap 0!, novisualpadding, alignx 100%, aligny 50%"));
        header.add((Component)this.browseStatusPanel, "alignx 0%, growx, pushx");
        this.headerBarDecorator.decorateBasic(header);
        this.sortAndFilterPanel.layoutComponents(header);
        searchResultsComponentsPanel.add((Component)header, "spanx 2, growx, growy, wrap");
        searchResultsComponentsPanel.add(this.filterPanel, "grow, spany 3");
        searchResultsComponentsPanel.add((Component)this.messagePanel, "spanx 1, growx, wrap");
        this.messagePanelsGap = Box.createVerticalStrut(6);
        searchResultsComponentsPanel.add(this.messagePanelsGap, "hidemode 3, spanx 1, growx, wrap");
        searchResultsComponentsPanel.add((Component)this.scrollPane, "hidemode 3, grow, spany");
        this.scrollablePanel.setScrollableTracksViewportHeight(false);
        this.scrollablePanel.setLayout(new BorderLayout());
        this.scrollablePanel.add((Component)this.resultsContainer, "Center");
        this.scrollablePanel.add((Component)this.sponsoredResultsPanel, "East");
        this.scrollPane.setViewportView(this.scrollablePanel);
        this.syncScrollPieces();
        return searchResultsComponentsPanel;
    }

    private void syncScrollPieces() {
        this.scrollablePanel.setScrollable(this.resultsContainer.getScrollable());
        this.syncColumnHeader();
    }

    public void setLifeCycleComplete(boolean lifeCycleComplete) {
        this.lifeCycleComplete = lifeCycleComplete;
        this.updateMessages();
    }

    public void setFullyConnected(boolean fullyConnected) {
        this.fullyConnected = fullyConnected;
        this.updateMessages();
    }

    public void setBrowseStatus(BrowseStatus browseStatus) {
        this.browseStatus = browseStatus;
        this.updateMessages();
    }

    private void updateMessages() {
        this.browseStatusPanel.setBrowseStatus(this.browseStatus);
        if (!this.fullyConnected && (this.receivedSearchResults || this.receivedSponsoredResults)) {
            this.messagePanel.setMessageType(SearchResultsMessagePanel.MessageType.CONNECTING_TO_ULTRAPEERS);
            this.messagePanelsGap.setVisible(true);
        } else if (this.fullyConnected && this.receivedSearchResults && this.messagePanel.isShowClassicSearchResultsHint()) {
            this.messagePanel.setMessageType(SearchResultsMessagePanel.MessageType.CLASSIC_SEARCH_RESULTS_HINT);
            this.messagePanelsGap.setVisible(true);
        } else {
            this.messagePanel.setMessageType(SearchResultsMessagePanel.MessageType.NONE);
            this.messagePanelsGap.setVisible(false);
        }
        if (!(this.lifeCycleComplete && this.fullyConnected || this.receivedSearchResults || this.receivedSponsoredResults)) {
            this.setOverlayType(OverlayType.AWAITING_CONNECTIONS);
        } else if (this.browseStatus != null && !this.browseStatus.getState().isOK()) {
            this.browseFailedPanel.update(this.browseStatus.getState(), this.browseStatus.getBrowseSearch(), this.browseStatus.getFailedFriends());
            this.setOverlayType(OverlayType.NO_FRIENDS_ON_LIMEWIRE);
        } else {
            this.setOverlayType(OverlayType.NONE);
        }
    }

    private class ScrollablePanel
    extends JXPanel {
        private Scrollable scrollable;

        private ScrollablePanel() {
        }

        public void setScrollable(Scrollable scrollable) {
            this.scrollable = scrollable;
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.scrollable == null) {
                return super.getPreferredSize();
            }
            int width = super.getPreferredSize().width;
            int height = ((JComponent)((Object)this.scrollable)).getPreferredSize().height;
            if (this.scrollable instanceof BaseResultPanel.ListViewTable) {
                if (SearchResultsPanel.this.sponsoredResultsPanel.isVisible()) {
                    height = Math.max(height, ((SearchResultsPanel)SearchResultsPanel.this).sponsoredResultsPanel.getPreferredSize().height);
                }
            } else {
                int headerHeight = 0;
                JTableHeader header = ((JTable)this.scrollable).getTableHeader();
                if (header != null && header.isShowing()) {
                    headerHeight = header.getHeight();
                }
                if (height < ((SearchResultsPanel)SearchResultsPanel.this).scrollPane.getSize().height - headerHeight) {
                    height = ((SearchResultsPanel)SearchResultsPanel.this).scrollPane.getSize().height - headerHeight;
                }
            }
            return new Dimension(width, height);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (this.scrollable == null) {
                return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
            }
            return this.scrollable.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (this.scrollable == null) {
                return super.getScrollableBlockIncrement(visibleRect, orientation, direction);
            }
            return this.scrollable.getScrollableBlockIncrement(visibleRect, orientation, direction);
        }
    }

    public static enum OverlayType {
        NONE,
        AWAITING_CONNECTIONS,
        NO_FRIENDS_ON_LIMEWIRE;

    }
}

