/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.LimeComboBox;
import org.limewire.ui.swing.components.decorators.ButtonDecorator;
import org.limewire.ui.swing.components.decorators.ComboBoxDecorator;
import org.limewire.ui.swing.painter.ButtonBackgroundPainter;
import org.limewire.ui.swing.search.SearchInspectionUtils;
import org.limewire.ui.swing.search.SearchViewType;
import org.limewire.ui.swing.search.model.SearchResultsModel;
import org.limewire.ui.swing.search.model.SortOption;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class SortAndFilterPanel
implements Disposable {
    private final ButtonDecorator buttonDecorator;
    private final SearchResultsModel searchResultsModel;
    private final Map<SortOption, Action> actionMap = new EnumMap<SortOption, Action>(SortOption.class);
    @Resource
    private Icon listViewIcon;
    @Resource
    private Icon tableViewIcon;
    @Resource
    private Font sortLabelFont;
    private final LimeComboBox sortCombo;
    private final JLabel sortLabel = new JLabel(I18n.tr("Sort by:"));
    private final JXButton listViewToggleButton = new JXButton();
    private final JXButton tableViewToggleButton = new JXButton();
    private SortOption sortBy;
    private boolean repopulatingCombo;
    private SettingListener viewTypeListener;

    @Inject
    SortAndFilterPanel(@Assisted SearchResultsModel searchResultsModel, ComboBoxDecorator comboBoxDecorator, ButtonDecorator buttonDecorator) {
        GuiUtils.assignResources(this);
        this.buttonDecorator = buttonDecorator;
        this.searchResultsModel = searchResultsModel;
        this.populateActionList();
        this.sortLabel.setFont(this.sortLabelFont);
        this.sortLabel.setForeground(Color.WHITE);
        this.sortCombo = new LimeComboBox();
        comboBoxDecorator.decorateDarkFullComboBox(this.sortCombo);
        this.sizeSortCombo();
        this.listViewToggleButton.setModel(new JToggleButton.ToggleButtonModel());
        this.tableViewToggleButton.setModel(new JToggleButton.ToggleButtonModel());
        this.setSearchCategory(searchResultsModel.getSearchCategory());
        this.configureViewButtons();
        this.configureSortFilter();
    }

    @Override
    public void dispose() {
        SwingUiSettings.SEARCH_VIEW_TYPE_ID.removeSettingListener(this.viewTypeListener);
    }

    private void sizeSortCombo() {
        int widestActionText = 0;
        FontMetrics sortFontMetrics = this.sortCombo.getFontMetrics(this.sortCombo.getFont());
        for (SortOption sortOption : this.actionMap.keySet()) {
            widestActionText = Math.max(widestActionText, sortFontMetrics.stringWidth(this.getDisplayName(sortOption)));
        }
        Dimension sortComboDimensions = new Dimension(widestActionText + 30, this.sortCombo.getPreferredSize().height);
        this.sortCombo.setPreferredSize(sortComboDimensions);
        this.sortCombo.setMinimumSize(sortComboDimensions);
        this.sortCombo.setMaximumSize(sortComboDimensions);
    }

    private void populateActionList() {
        for (SortOption sortOption : SortOption.values()) {
            this.actionMap.put(sortOption, new SortAction(sortOption));
        }
    }

    private void configureViewButtons() {
        this.buttonDecorator.decorateDarkFullImageButton(this.listViewToggleButton, ButtonBackgroundPainter.DrawMode.LEFT_ROUNDED);
        this.listViewToggleButton.setIcon(this.listViewIcon);
        this.listViewToggleButton.setPressedIcon(this.listViewIcon);
        this.listViewToggleButton.setToolTipText(I18n.tr("List view"));
        this.listViewToggleButton.setMargin(new Insets(0, 10, 0, 6));
        this.listViewToggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    SwingUiSettings.SEARCH_VIEW_TYPE_ID.setValue(SearchViewType.LIST.getId());
                    SortAndFilterPanel.this.selectListView();
                }
            }
        });
        this.buttonDecorator.decorateDarkFullImageButton(this.tableViewToggleButton, ButtonBackgroundPainter.DrawMode.RIGHT_ROUNDED);
        this.tableViewToggleButton.setIcon(this.tableViewIcon);
        this.tableViewToggleButton.setPressedIcon(this.tableViewIcon);
        this.tableViewToggleButton.setToolTipText(I18n.tr("Classic view"));
        this.tableViewToggleButton.setMargin(new Insets(0, 6, 0, 10));
        this.tableViewToggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    SwingUiSettings.SEARCH_VIEW_TYPE_ID.setValue(SearchViewType.TABLE.getId());
                    SwingUiSettings.SHOW_CLASSIC_REMINDER.setValue(false);
                    SortAndFilterPanel.this.selectTableView();
                }
            }
        });
        this.viewTypeListener = new SettingListener(){

            @Override
            public void settingChanged(SettingEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int newViewTypeId = SwingUiSettings.SEARCH_VIEW_TYPE_ID.getValue();
                        SearchViewType newSearchViewType = SearchViewType.forId(newViewTypeId);
                        SortAndFilterPanel.this.updateView(newSearchViewType);
                    }
                });
            }
        };
        SwingUiSettings.SEARCH_VIEW_TYPE_ID.addSettingListener(this.viewTypeListener);
        ButtonGroup viewGroup = new ButtonGroup();
        viewGroup.add(this.listViewToggleButton);
        viewGroup.add(this.tableViewToggleButton);
        int viewTypeId = SwingUiSettings.SEARCH_VIEW_TYPE_ID.getValue();
        SearchViewType searchViewType = SearchViewType.forId(viewTypeId);
        this.updateView(searchViewType);
    }

    private void updateView(SearchViewType newSearchViewType) {
        switch (newSearchViewType) {
            case LIST: {
                this.selectListView();
                break;
            }
            case TABLE: {
                this.selectTableView();
            }
        }
    }

    private void selectListView() {
        this.tableViewToggleButton.setSelected(false);
        this.listViewToggleButton.setSelected(true);
        this.sortLabel.setVisible(true);
        this.sortCombo.setVisible(true);
    }

    private void selectTableView() {
        this.tableViewToggleButton.setSelected(true);
        this.listViewToggleButton.setSelected(false);
        this.sortLabel.setVisible(false);
        this.sortCombo.setVisible(false);
    }

    private void configureSortFilter() {
        this.searchResultsModel.setSortOption(SortOption.getDefault());
        LimeComboBox.SelectionListener listener = new LimeComboBox.SelectionListener(){

            @Override
            public void selectionChanged(Action action) {
                SortOption option = ((SortAction)action).getSortOption();
                if (!SortAndFilterPanel.this.repopulatingCombo && !option.equals((Object)SortAndFilterPanel.this.sortBy)) {
                    SortAndFilterPanel.this.searchResultsModel.setSortOption(option);
                    SortAndFilterPanel.this.sortBy = option;
                }
            }
        };
        this.sortCombo.addSelectionListener(listener);
        this.sortCombo.setSelectedAction(this.actionMap.get((Object)SortOption.getDefault()));
    }

    public void layoutComponents(JPanel panel) {
        panel.add((Component)this.sortLabel, "gapafter 5, gapbottom 2, hidemode 0");
        panel.add((Component)this.sortCombo, "gapafter 10, hidemode 0");
        panel.add((Component)this.listViewToggleButton, "right");
        panel.add((Component)this.tableViewToggleButton, "gapafter 5");
    }

    public void setMode(SearchViewType mode) {
        if (mode == SearchViewType.LIST) {
            this.listViewToggleButton.setSelected(true);
            this.tableViewToggleButton.setSelected(false);
        } else if (mode == SearchViewType.TABLE) {
            this.listViewToggleButton.setSelected(false);
            this.tableViewToggleButton.setSelected(true);
        }
    }

    public void setSearchCategory(SearchCategory category) {
        Action currentItem = this.sortCombo.getSelectedAction();
        boolean currentValid = false;
        this.repopulatingCombo = true;
        this.sortCombo.removeAllActions();
        SortOption[] options = SortOption.getSortOptions(category);
        LinkedList<Action> actionList = new LinkedList<Action>();
        for (SortOption option : options) {
            actionList.add(this.actionMap.get((Object)option));
            if (!this.actionMap.get((Object)option).equals(currentItem)) continue;
            currentValid = true;
        }
        this.sortCombo.addActions(actionList);
        this.sizeSortCombo();
        this.repopulatingCombo = false;
        if (currentValid) {
            this.sortCombo.setSelectedAction(currentItem);
        } else {
            this.searchResultsModel.setSortOption(options[0]);
            this.sortBy = options[0];
        }
    }

    private String getDisplayName(SortOption sortOption) {
        switch (sortOption) {
            case COMPANY: {
                return I18n.tr("Company");
            }
            case PLATFORM: {
                return I18n.tr("Platform");
            }
            case TYPE: {
                return I18n.tr("Type");
            }
            case DATE_CREATED: {
                return I18n.tr("Date Created");
            }
            case QUALITY: {
                return I18n.tr("Quality");
            }
            case YEAR: {
                return I18n.tr("Year");
            }
            case FILE_EXTENSION: {
                return I18n.tr("File Extension");
            }
            case TITLE: {
                return I18n.tr("Title");
            }
            case LENGTH: {
                return I18n.tr("Length");
            }
            case ALBUM: {
                return I18n.tr("Album");
            }
            case ARTIST: {
                return I18n.tr("Artist");
            }
            case SIZE_LOW_TO_HIGH: {
                return I18n.tr("Size (low to high)");
            }
            case SIZE_HIGH_TO_LOW: {
                return I18n.tr("Size (high to low)");
            }
            case CATEGORY: {
                return I18n.tr("Category");
            }
            case NAME: {
                return I18n.tr("Name");
            }
            case RELEVANCE_ITEM: {
                return I18n.tr("Relevance");
            }
        }
        return sortOption.name();
    }

    private class SortAction
    extends AbstractAction {
        private final SortOption sortOption;

        public SortAction(SortOption sortOption) {
            super(SortAndFilterPanel.this.getDisplayName(sortOption));
            this.sortOption = sortOption;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchInspectionUtils.searchSorted();
        }

        public SortOption getSortOption() {
            return this.sortOption;
        }
    }
}

