/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.VerticalLayout;
import org.limewire.core.api.Application;
import org.limewire.core.api.search.sponsored.SponsoredResult;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.home.HomeMediator;
import org.limewire.ui.swing.listener.ActionHandListener;
import org.limewire.ui.swing.mainframe.StoreMediator;
import org.limewire.ui.swing.nav.NavCategory;
import org.limewire.ui.swing.nav.Navigator;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.NativeLaunchUtils;
import org.mozilla.browser.MozillaInitialization;

public class SponsoredResultsPanel
extends JXPanel {
    private final Application application;
    private final Navigator navigator;
    private final HomeMediator homeMediator;
    private final StoreMediator storeMediator;
    @Resource
    private int textWidth;
    @Resource
    private int areaWidth;
    @Resource
    private Color headingColor;
    @Resource
    private Color bodyColor;
    @Resource
    private Color urlColor;
    @Resource
    private Font headingFont;
    @Resource
    private Font bodyFont;
    @Resource
    private Font urlFont;

    @Inject
    public SponsoredResultsPanel(Navigator navigator, StoreMediator storeMediator, HomeMediator homeMediator, Application application) {
        GuiUtils.assignResources(this);
        this.application = application;
        this.navigator = navigator;
        this.storeMediator = storeMediator;
        this.homeMediator = homeMediator;
        this.setLayout(new VerticalLayout(10));
        this.setBorder(BorderFactory.createEmptyBorder(8, 5, 0, 0));
        this.setMaximumSize(new Dimension(this.areaWidth, Integer.MAX_VALUE));
        this.setMinimumSize(new Dimension(this.areaWidth, Short.MAX_VALUE));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = this.areaWidth;
        return d;
    }

    public void addEntry(SponsoredResult result) {
        this.add(new SponsoredResultView(result));
    }

    private class SponsoredResultListener
    implements ActionListener {
        private final SponsoredResult result;

        public SponsoredResultListener(SponsoredResult result) {
            this.result = result;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!MozillaInitialization.isInitialized()) {
                NativeLaunchUtils.openURL(SponsoredResultsPanel.this.application.addClientInfoToUrl(this.result.getUrl()));
            } else {
                switch (this.result.getTarget()) {
                    case HOME: {
                        SponsoredResultsPanel.this.homeMediator.getComponent().load(this.result.getUrl());
                        SponsoredResultsPanel.this.navigator.getNavItem(NavCategory.LIMEWIRE, "Home").select();
                        break;
                    }
                    case STORE: {
                        SponsoredResultsPanel.this.storeMediator.load(this.result.getUrl());
                        break;
                    }
                    default: {
                        NativeLaunchUtils.openURL(SponsoredResultsPanel.this.application.addClientInfoToUrl(this.result.getUrl()));
                    }
                }
            }
        }
    }

    private class SponsoredResultView
    extends JPanel {
        public SponsoredResultView(SponsoredResult result) {
            super(new VerticalLayout());
            MultiLineLabel link = new MultiLineLabel("<html><u>" + result.getTitle() + "</u><html>", SponsoredResultsPanel.this.textWidth);
            link.setForeground(SponsoredResultsPanel.this.headingColor);
            link.setFont(SponsoredResultsPanel.this.headingFont);
            link.addMouseListener(new ActionHandListener(new SponsoredResultListener(result)));
            link.setBorder(BorderFactory.createEmptyBorder());
            MultiLineLabel textArea = new MultiLineLabel(result.getText(), SponsoredResultsPanel.this.textWidth);
            textArea.setForeground(SponsoredResultsPanel.this.bodyColor);
            textArea.setFont(SponsoredResultsPanel.this.bodyFont);
            textArea.setBorder(BorderFactory.createEmptyBorder());
            JLabel urlLabel = new JLabel(result.getVisibleUrl());
            urlLabel.setForeground(SponsoredResultsPanel.this.urlColor);
            urlLabel.setFont(SponsoredResultsPanel.this.urlFont);
            urlLabel.setBorder(BorderFactory.createEmptyBorder());
            this.add(link);
            this.add(textArea);
            this.add(urlLabel);
        }
    }
}

