/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.advanced;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXPanel;
import org.limewire.core.api.Category;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.library.FriendAutoCompleterFactory;
import org.limewire.core.api.properties.PropertyDictionary;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.HeaderBar;
import org.limewire.ui.swing.components.decorators.ButtonDecorator;
import org.limewire.ui.swing.components.decorators.HeaderBarDecorator;
import org.limewire.ui.swing.search.KeywordAssistedSearchBuilder;
import org.limewire.ui.swing.search.SearchInfo;
import org.limewire.ui.swing.search.UiSearchListener;
import org.limewire.ui.swing.search.advanced.AdvancedAudioPanel;
import org.limewire.ui.swing.search.advanced.AdvancedDocumentPanel;
import org.limewire.ui.swing.search.advanced.AdvancedImagePanel;
import org.limewire.ui.swing.search.advanced.AdvancedPanel;
import org.limewire.ui.swing.search.advanced.AdvancedProgramPanel;
import org.limewire.ui.swing.search.advanced.AdvancedVideoPanel;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.ResizeUtils;

public class AdvancedSearchPanel
extends JXPanel
implements Disposable {
    private final FriendAutoCompleterFactory friendAutoCompleterFactory;
    private final Provider<KeywordAssistedSearchBuilder> advancedSearchBuilder;
    private final PropertyDictionary propertyDictionary;
    private final ButtonDecorator buttonDecorator;
    private final Action searchAction = new SearchAction();
    private final List<UiSearchListener> uiSearchListeners = new CopyOnWriteArrayList<UiSearchListener>();
    private Map<Category, AdvancedPanel> advancedPanels = new HashMap<Category, AdvancedPanel>();
    private AdvancedPanel visibleComponent = null;
    private final JPanel selectorPanel;
    private final JPanel inputPanel;
    @Resource
    private Font headingFont;
    private final JXButton searchButton = new JXButton(this.searchAction);

    @Inject
    public AdvancedSearchPanel(PropertyDictionary propertyDictionary, FriendAutoCompleterFactory friendAutoCompleterFactory, HeaderBarDecorator headerDecorator, ButtonDecorator buttonDecorator, Provider<KeywordAssistedSearchBuilder> advancedSearchBuilder) {
        this.propertyDictionary = propertyDictionary;
        this.friendAutoCompleterFactory = friendAutoCompleterFactory;
        this.buttonDecorator = buttonDecorator;
        this.advancedSearchBuilder = advancedSearchBuilder;
        GuiUtils.assignResources(this);
        this.setLayout(new MigLayout("insets 0, gap 0, hidemode 3"));
        HeaderBar heading = new HeaderBar(I18n.tr("Advanced Search"));
        headerDecorator.decorateBasic(heading);
        JLabel description = new JLabel(I18n.tr("Search for the following category:"));
        description.setFont(this.headingFont);
        this.add((Component)heading, "dock north");
        this.add((Component)description, "gapleft 15, gaptop 15, wrap");
        this.selectorPanel = new JPanel(new FlowLayout());
        this.selectorPanel.setOpaque(false);
        this.add((Component)this.selectorPanel, "gapleft 30, gaptop 5, wrap");
        this.inputPanel = new JPanel(new MigLayout("insets 0, gap 0, hidemode 3, wrap"));
        this.addCategory(SearchCategory.AUDIO);
        this.addCategory(SearchCategory.VIDEO);
        this.addCategory(SearchCategory.IMAGE);
        this.addCategory(SearchCategory.DOCUMENT);
        this.addCategory(SearchCategory.PROGRAM);
        buttonDecorator.decorateGreenFullButton(this.searchButton);
        this.searchButton.setFont(this.headingFont);
        this.searchButton.setVisible(false);
        this.inputPanel.add((Component)this.searchButton, "cell 0 1, gapbefore push, gapright 5, gaptop 5");
        this.add((Component)this.inputPanel, "gapleft 45, gaptop 4");
    }

    private AdvancedPanel createAdvancedPanel(Category category) {
        AbstractAction enterKeyAction = new AbstractAction("pressed"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedSearchPanel.this.searchButton.doClick();
            }
        };
        AdvancedPanel panel = null;
        if (category == Category.AUDIO) {
            panel = new AdvancedAudioPanel(this.propertyDictionary, this.friendAutoCompleterFactory, (Action)enterKeyAction);
        } else if (category == Category.VIDEO) {
            panel = new AdvancedVideoPanel(this.propertyDictionary, this.friendAutoCompleterFactory, (Action)enterKeyAction);
        } else if (category == Category.DOCUMENT) {
            panel = new AdvancedDocumentPanel(this.friendAutoCompleterFactory, enterKeyAction);
        } else if (category == Category.IMAGE) {
            panel = new AdvancedImagePanel(this.friendAutoCompleterFactory, enterKeyAction);
        } else if (category == Category.PROGRAM) {
            panel = new AdvancedProgramPanel(this.friendAutoCompleterFactory, enterKeyAction);
        }
        return panel;
    }

    private void addCategory(final SearchCategory category) {
        final JXButton button = new JXButton(I18n.tr(category.getCategory().getPluralName()));
        button.setModel(new JToggleButton.ToggleButtonModel());
        this.buttonDecorator.decorateLinkButton(button);
        button.setFont(this.headingFont);
        FontUtils.underline(button);
        this.selectorPanel.add(button);
        button.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    AdvancedPanel component = (AdvancedPanel)AdvancedSearchPanel.this.advancedPanels.get((Object)category.getCategory());
                    if (component == null) {
                        component = AdvancedSearchPanel.this.createAdvancedPanel(category.getCategory());
                        AdvancedSearchPanel.this.advancedPanels.put(category.getCategory(), component);
                        ResizeUtils.forceWidth(component, 300);
                        AdvancedSearchPanel.this.inputPanel.add((Component)component, "cell 0 0, wrap");
                    }
                    if (AdvancedSearchPanel.this.visibleComponent != null) {
                        AdvancedSearchPanel.this.visibleComponent.setVisible(false);
                    }
                    component.setVisible(true);
                    AdvancedSearchPanel.this.visibleComponent = component;
                    AdvancedSearchPanel.this.updateSelection(button);
                    AdvancedSearchPanel.this.searchButton.setVisible(true);
                }
            }
        });
    }

    private void updateSelection(JButton button) {
        button.setSelected(true);
        for (Component comp : this.selectorPanel.getComponents()) {
            if (!(comp instanceof JButton) || button == comp) continue;
            ((JButton)comp).setSelected(false);
        }
    }

    public void addSearchListener(UiSearchListener uiSearchListener) {
        this.uiSearchListeners.add(uiSearchListener);
    }

    @Override
    public void dispose() {
        this.uiSearchListeners.clear();
    }

    private class SearchAction
    extends AbstractAction {
        public SearchAction() {
            super(I18n.tr("Search"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Map<FilePropertyKey, String> searchData;
            if (AdvancedSearchPanel.this.visibleComponent != null && (searchData = AdvancedSearchPanel.this.visibleComponent.getSearchData()) != null) {
                SearchInfo info = ((KeywordAssistedSearchBuilder)AdvancedSearchPanel.this.advancedSearchBuilder.get()).createAdvancedSearch(searchData, AdvancedSearchPanel.this.visibleComponent.getSearchCategory());
                for (UiSearchListener uiSearchListener : AdvancedSearchPanel.this.uiSearchListeners) {
                    uiSearchListener.searchTriggered(info);
                }
            }
        }
    }
}

