/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.limewire.ui.swing.search.model.AbstractSimilarResultsDetector;
import org.limewire.ui.swing.search.model.BasicDownloadState;
import org.limewire.ui.swing.search.model.CleanStringCache;
import org.limewire.ui.swing.search.model.VisualSearchResult;

public abstract class AbstractNameSimilarResultsDetector
extends AbstractSimilarResultsDetector {
    protected final CleanStringCache nameCache;
    protected final Map<String, VisualSearchResult> matchCache;

    public AbstractNameSimilarResultsDetector(Pattern pattern) {
        this.nameCache = new CleanStringCache(pattern, "");
        this.matchCache = new HashMap<String, VisualSearchResult>();
    }

    @Override
    public void detectSimilarResult(VisualSearchResult visualSearchResult) {
        if (!visualSearchResult.isSpam() && visualSearchResult.getDownloadState() != BasicDownloadState.LIBRARY && !visualSearchResult.isPreExistingDownload()) {
            Set<String> names = this.getCleanIdentifyingStrings(visualSearchResult);
            VisualSearchResult parent = null;
            for (String name : names) {
                parent = this.matchCache.get(name);
                if (parent == null) {
                    this.matchCache.put(name, visualSearchResult);
                    continue;
                }
                if (parent == visualSearchResult) continue;
                parent = this.update(parent, visualSearchResult);
                this.matchCache.put(name, parent);
            }
        }
    }

    @Override
    public void removeSpamItem(VisualSearchResult visualSearchResult, VisualSearchResult newParent) {
        Set<String> names = this.getCleanIdentifyingStrings(visualSearchResult);
        for (String name : names) {
            VisualSearchResult master = this.matchCache.get(name);
            if (master != visualSearchResult) continue;
            this.matchCache.put(name, newParent);
        }
    }

    @Override
    public void clear() {
        this.matchCache.clear();
    }

    public CleanStringCache getNameCache() {
        return this.nameCache;
    }

    public abstract Set<String> getCleanIdentifyingStrings(VisualSearchResult var1);
}

