/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.model;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.limewire.core.api.Category;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.search.SearchResult;
import org.limewire.ui.swing.search.model.AbstractNameSimilarResultsDetector;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.util.StringUtils;

public class AudioMetaDataSimilarResultsDetector
extends AbstractNameSimilarResultsDetector {
    private static final String REPLACE = "\\(\\d*\\)|[-_. ()\\d]";

    public AudioMetaDataSimilarResultsDetector() {
        super(Pattern.compile(REPLACE));
    }

    @Override
    public void detectSimilarResult(VisualSearchResult visualSearchResult) {
        if (visualSearchResult.getCategory() == Category.AUDIO) {
            super.detectSimilarResult(visualSearchResult);
        }
    }

    @Override
    public Set<String> getCleanIdentifyingStrings(VisualSearchResult visualSearchResult) {
        HashSet<String> names = new HashSet<String>();
        for (SearchResult searchResult : visualSearchResult.getCoreSearchResults()) {
            this.addNames(names, searchResult);
        }
        return names;
    }

    private void addNames(Set<String> names, SearchResult searchResult) {
        Map<FilePropertyKey, String> metaData = this.getMetadata(searchResult);
        String artist = metaData.get((Object)FilePropertyKey.AUTHOR);
        String album = metaData.get((Object)FilePropertyKey.ALBUM);
        String track = metaData.get((Object)FilePropertyKey.TITLE);
        if (!StringUtils.isEmpty(track)) {
            if (!StringUtils.isEmpty(artist)) {
                String artistTrack = metaData.get((Object)FilePropertyKey.AUTHOR) + "-" + metaData.get((Object)FilePropertyKey.TITLE);
                names.add(artistTrack);
                if (!StringUtils.isEmpty(album)) {
                    String artistAlbumTrack = metaData.get((Object)FilePropertyKey.AUTHOR) + "-" + metaData.get((Object)FilePropertyKey.ALBUM) + "-" + metaData.get((Object)FilePropertyKey.TITLE);
                    names.add(artistAlbumTrack);
                }
            }
            if (!StringUtils.isEmpty(album)) {
                String albumTrack = metaData.get((Object)FilePropertyKey.ALBUM) + "-" + metaData.get((Object)FilePropertyKey.TITLE);
                names.add(albumTrack);
            }
        }
    }

    private Map<FilePropertyKey, String> getMetadata(SearchResult result) {
        String name = result.getProperty(FilePropertyKey.NAME).toString();
        EnumMap<FilePropertyKey, String> metadataCopy = new EnumMap<FilePropertyKey, String>(FilePropertyKey.class);
        this.copyProperty(result, metadataCopy, FilePropertyKey.TITLE);
        this.copyProperty(result, metadataCopy, FilePropertyKey.ALBUM);
        this.copyProperty(result, metadataCopy, FilePropertyKey.AUTHOR);
        StringTokenizer st = new StringTokenizer(name, "-");
        Stack<String> nameParts = new Stack<String>();
        while (st.hasMoreElements()) {
            String part = st.nextToken().trim();
            nameParts.push(part);
        }
        if (!nameParts.empty()) {
            String trackName = (String)nameParts.pop();
            if (StringUtils.isEmpty((String)metadataCopy.get((Object)FilePropertyKey.TITLE))) {
                metadataCopy.put(FilePropertyKey.TITLE, trackName);
            }
            if (!nameParts.empty()) {
                String albumOrArtist = (String)nameParts.pop();
                if (StringUtils.isEmpty((String)metadataCopy.get((Object)FilePropertyKey.ALBUM))) {
                    metadataCopy.put(FilePropertyKey.ALBUM, albumOrArtist);
                }
                if (!nameParts.empty()) {
                    String artist = (String)nameParts.pop();
                    if (StringUtils.isEmpty((String)metadataCopy.get((Object)FilePropertyKey.AUTHOR))) {
                        metadataCopy.put(FilePropertyKey.AUTHOR, artist);
                    }
                }
            }
        }
        this.cleanProperty(metadataCopy, FilePropertyKey.TITLE);
        this.cleanProperty(metadataCopy, FilePropertyKey.ALBUM);
        this.cleanProperty(metadataCopy, FilePropertyKey.AUTHOR);
        return metadataCopy;
    }

    private void copyProperty(SearchResult result, Map<FilePropertyKey, String> metadataCopy, FilePropertyKey propertyKey) {
        metadataCopy.put(propertyKey, result.getProperty(propertyKey) == null ? "" : result.getProperty(propertyKey).toString());
    }

    private void cleanProperty(Map<FilePropertyKey, String> metadataCopy, FilePropertyKey propertyKey) {
        String cleanedProperty = this.getNameCache().getCleanString(metadataCopy.get((Object)propertyKey));
        metadataCopy.put(propertyKey, cleanedProperty);
    }
}

