/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.model;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import com.google.inject.Provider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.URN;
import org.limewire.core.api.download.DownloadAction;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadListManager;
import org.limewire.core.api.search.GroupedSearchResult;
import org.limewire.core.api.search.Search;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.core.api.search.SearchDetails;
import org.limewire.core.api.search.SearchListener;
import org.limewire.core.api.search.SearchManager;
import org.limewire.core.api.search.SearchResultList;
import org.limewire.listener.EventListener;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.components.DisposalListener;
import org.limewire.ui.swing.filter.FilterDebugger;
import org.limewire.ui.swing.search.SearchInfo;
import org.limewire.ui.swing.search.model.BasicDownloadState;
import org.limewire.ui.swing.search.model.DownloadItemPropertyListener;
import org.limewire.ui.swing.search.model.SearchResultsModel;
import org.limewire.ui.swing.search.model.SortFactory;
import org.limewire.ui.swing.search.model.SortOption;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.model.VisualSearchResultFactory;
import org.limewire.ui.swing.search.model.VisualSearchResultStatusListener;
import org.limewire.ui.swing.util.DownloadExceptionHandler;

class BasicSearchResultsModel
implements SearchResultsModel,
VisualSearchResultStatusListener {
    private static final Log LOG = LogFactory.getLog(BasicSearchResultsModel.class);
    private final FilterDebugger<VisualSearchResult> filterDebugger;
    private final SearchInfo searchInfo;
    private final Search search;
    private final SearchManager searchManager;
    private final SearchResultList searchResultList;
    private final DownloadListManager downloadListManager;
    private final Provider<DownloadExceptionHandler> downloadExceptionHandler;
    private final VisualSearchResultFactory vsrFactory;
    private final EventList<VisualSearchResult> groupedUrnResults;
    private final FilterList<VisualSearchResult> filteredResultList;
    private SearchListener searchListener;
    private EventListener<Collection<GroupedSearchResult>> searchListListener;
    private SortedList<VisualSearchResult> sortedResultList;
    private FilterList<VisualSearchResult> visibleResultList;
    private SearchCategory selectedCategory;
    private SortOption sortOption;
    private MatcherEditor<VisualSearchResult> filterEditor;
    private MatcherEditor.Listener<VisualSearchResult> filterEditorListener;
    private final VisibleMatcherEditor visibleEditor = new VisibleMatcherEditor();
    private List<DisposalListener> disposalListeners = new ArrayList<DisposalListener>();
    private final List<VisualSearchResultStatusListener> changeListeners;
    private final UrnResultFinder resultFinder = new UrnResultFinder();
    private boolean cleared = false;

    public BasicSearchResultsModel(SearchInfo searchInfo, Search search, VisualSearchResultFactory vsrFactory, DownloadListManager downloadListManager, Provider<DownloadExceptionHandler> downloadExceptionHandler, SearchManager searchManager) {
        this.searchInfo = searchInfo;
        this.search = search;
        this.vsrFactory = vsrFactory;
        this.searchManager = searchManager;
        this.downloadListManager = downloadListManager;
        this.downloadExceptionHandler = downloadExceptionHandler;
        this.changeListeners = new ArrayList<VisualSearchResultStatusListener>(3);
        this.filterDebugger = new FilterDebugger();
        this.searchResultList = searchManager.addSearch(search, searchInfo);
        this.groupedUrnResults = new BasicEventList<VisualSearchResult>();
        this.filteredResultList = GlazedListsFactory.filterList(this.groupedUrnResults);
        this.setSelectedCategory(searchInfo.getSearchCategory());
    }

    @Override
    public void start(SearchListener searchListener) {
        if (searchListener == null) {
            throw new IllegalArgumentException("Search listener cannot be null");
        }
        this.searchListener = searchListener;
        this.search.addSearchListener(searchListener);
        this.searchListListener = new EventListener<Collection<GroupedSearchResult>>(){

            @Override
            public void handleEvent(Collection<GroupedSearchResult> results) {
                final ArrayList<GroupedSearchResult> resultList = new ArrayList<GroupedSearchResult>(results);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BasicSearchResultsModel.this.addResultsInternal(0, resultList);
                    }
                });
            }
        };
        this.searchResultList.addListener(this.searchListListener);
        this.search.start();
    }

    void addResultsInternal(int startIdx, final List<GroupedSearchResult> resultList) {
        final int endIdx = Math.min(startIdx + 1000, resultList.size());
        for (int i = startIdx; i < endIdx; ++i) {
            GroupedSearchResult gsr = resultList.get(i);
            URN urn = gsr.getUrn();
            int idx = Collections.binarySearch(this.groupedUrnResults, urn, this.resultFinder);
            if (idx >= 0) continue;
            idx = -(idx + 1);
            VisualSearchResult vsr = this.vsrFactory.create(gsr, this);
            this.groupedUrnResults.add(idx, vsr);
            for (VisualSearchResultStatusListener listener : this.changeListeners) {
                listener.resultCreated(vsr);
            }
        }
        if (endIdx < resultList.size()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BasicSearchResultsModel.this.addResultsInternal(endIdx, resultList);
                }
            });
        } else if (this.sortedResultList != null) {
            this.sortedResultList.setComparator(this.sortedResultList.getComparator());
        }
    }

    @Override
    public void dispose() {
        this.search.stop();
        if (this.searchListener != null) {
            this.search.removeSearchListener(this.searchListener);
            this.searchListener = null;
        }
        if (this.searchListListener != null) {
            this.searchResultList.removeListener(this.searchListListener);
            this.searchListListener = null;
        }
        this.searchManager.removeSearch(this.search);
        this.groupedUrnResults.dispose();
        this.notifyDisposalListeners();
    }

    @Override
    public SearchCategory getFilterCategory() {
        return this.searchInfo.getSearchCategory();
    }

    @Override
    public FilterDebugger<VisualSearchResult> getFilterDebugger() {
        return this.filterDebugger;
    }

    @Override
    public EventList<VisualSearchResult> getUnfilteredList() {
        return this.groupedUrnResults;
    }

    @Override
    public EventList<VisualSearchResult> getFilteredList() {
        return this.filteredResultList;
    }

    @Override
    public SearchCategory getSearchCategory() {
        return this.searchInfo.getSearchCategory();
    }

    @Override
    public String getSearchQuery() {
        return this.searchInfo.getSearchQuery();
    }

    @Override
    public String getSearchTitle() {
        return this.searchInfo.getTitle();
    }

    @Override
    public int getResultCount() {
        return this.searchResultList.getResultCount();
    }

    @Override
    public SearchDetails.SearchType getSearchType() {
        return this.searchInfo.getSearchType();
    }

    @Override
    public EventList<VisualSearchResult> getFilteredSearchResults() {
        return this.filteredResultList;
    }

    @Override
    public EventList<VisualSearchResult> getSortedSearchResults() {
        return this.visibleResultList;
    }

    @Override
    public SearchCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    @Override
    public void setSelectedCategory(SearchCategory selectedCategory) {
        if (this.selectedCategory != selectedCategory) {
            this.selectedCategory = selectedCategory;
            this.updateSortedList();
        }
    }

    private void updateSortedList() {
        if (this.visibleResultList == null) {
            this.sortedResultList = GlazedListsFactory.sortedList(this.filteredResultList, this.sortOption != null ? SortFactory.getSortComparator(this.sortOption) : null);
            this.visibleResultList = GlazedListsFactory.filterList(this.sortedResultList, this.visibleEditor);
        }
    }

    @Override
    public void setSortOption(SortOption sortOption) {
        this.sortOption = sortOption;
        this.sortedResultList.setComparator(sortOption != null ? SortFactory.getSortComparator(sortOption) : null);
    }

    @Override
    public void setFilterEditor(MatcherEditor<VisualSearchResult> editor) {
        if (this.filterEditor != null && this.filterEditorListener != null) {
            this.filterEditor.removeMatcherEditorListener(this.filterEditorListener);
        }
        if (this.filterEditorListener == null) {
            this.filterEditorListener = new MatcherEditor.Listener<VisualSearchResult>(){

                @Override
                public void changedMatcher(MatcherEditor.Event<VisualSearchResult> matcherEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BasicSearchResultsModel.this.visibleEditor.update();
                        }
                    });
                }
            };
        }
        this.filterEditor = editor;
        this.filterEditor.addMatcherEditorListener(this.filterEditorListener);
        this.filteredResultList.setMatcherEditor(this.filterEditor);
    }

    public void addResultListener(VisualSearchResultStatusListener vsrChangeListener) {
        this.changeListeners.add(vsrChangeListener);
    }

    @Override
    public void resultCreated(VisualSearchResult vsr) {
    }

    @Override
    public void resultsCleared() {
    }

    @Override
    public void resultChanged(VisualSearchResult vsr, String propertyName, Object oldValue, Object newValue) {
        block6: {
            block5: {
                if (!"newSources".equals(propertyName)) break block5;
                for (VisualSearchResultStatusListener listener : this.changeListeners) {
                    listener.resultChanged(vsr, "newSources", null, null);
                }
                break block6;
            }
            URN urn = vsr.getUrn();
            int idx = Collections.binarySearch(this.groupedUrnResults, urn, this.resultFinder);
            assert (this.cleared || idx >= 0);
            if (idx < 0) break block6;
            VisualSearchResult existing = (VisualSearchResult)this.groupedUrnResults.get(idx);
            VisualSearchResult replaced = this.groupedUrnResults.set(idx, existing);
            assert (this.cleared || replaced == vsr);
            if (replaced == vsr) {
                for (VisualSearchResultStatusListener listener : this.changeListeners) {
                    listener.resultChanged(vsr, propertyName, oldValue, newValue);
                }
            }
        }
    }

    @Override
    public void clear() {
        this.cleared = true;
        this.searchResultList.clear();
        this.groupedUrnResults.clear();
        for (VisualSearchResultStatusListener listener : this.changeListeners) {
            listener.resultsCleared();
        }
    }

    @Override
    public void download(VisualSearchResult vsr) {
        this.download(vsr, null);
    }

    @Override
    public void download(final VisualSearchResult vsr, File saveFile) {
        try {
            DownloadItem di = saveFile == null ? this.downloadListManager.addDownload(this.search, vsr.getCoreSearchResults()) : this.downloadListManager.addDownload(this.search, vsr.getCoreSearchResults(), saveFile, true);
            di.addPropertyChangeListener(new DownloadItemPropertyListener(vsr));
            BasicDownloadState state = BasicDownloadState.fromState(di.getState());
            if (state != null) {
                vsr.setDownloadState(state);
            }
        }
        catch (DownloadException e) {
            if (e.getErrorCode() == DownloadException.ErrorCode.FILE_ALREADY_DOWNLOADING) {
                DownloadItem downloadItem = this.downloadListManager.getDownloadItem(vsr.getUrn());
                if (downloadItem != null) {
                    downloadItem.addPropertyChangeListener(new DownloadItemPropertyListener(vsr));
                    BasicDownloadState state = BasicDownloadState.fromState(downloadItem.getState());
                    if (state != null) {
                        vsr.setDownloadState(state);
                    }
                    if (saveFile != null) {
                        try {
                            downloadItem.setSaveFile(saveFile, true);
                        }
                        catch (DownloadException ex) {
                            LOG.infof(ex, "Unable to relocate downloading file {0}", ex.getMessage());
                        }
                    }
                }
            }
            this.downloadExceptionHandler.get().handleDownloadException(new DownloadAction(){

                @Override
                public void download(File saveFile, boolean overwrite) throws DownloadException {
                    DownloadItem di = BasicSearchResultsModel.this.downloadListManager.addDownload(BasicSearchResultsModel.this.search, vsr.getCoreSearchResults(), saveFile, overwrite);
                    di.addPropertyChangeListener(new DownloadItemPropertyListener(vsr));
                    BasicDownloadState state = BasicDownloadState.fromState(di.getState());
                    if (state != null) {
                        vsr.setDownloadState(state);
                    }
                }

                @Override
                public void downloadCanceled(DownloadException ignored) {
                }
            }, e, true);
        }
    }

    private boolean isFilterMatch(VisualSearchResult vsr) {
        if (this.filterEditor != null) {
            return this.filterEditor.getMatcher().matches(vsr);
        }
        return true;
    }

    @Override
    public void addDisposalListener(DisposalListener listener) {
        this.disposalListeners.add(listener);
    }

    @Override
    public void removeDisposalListener(DisposalListener listener) {
        this.disposalListeners.remove(listener);
    }

    private void notifyDisposalListeners() {
        for (DisposalListener listener : this.disposalListeners) {
            listener.objectDisposed(this);
        }
    }

    private static class UrnResultFinder
    implements Comparator<Object> {
        private UrnResultFinder() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return ((VisualSearchResult)o1).getUrn().compareTo((URN)o2);
        }
    }

    private class VisibleMatcherEditor
    extends AbstractMatcherEditor<VisualSearchResult> {
        public VisibleMatcherEditor() {
            this.currentMatcher = new Matcher<VisualSearchResult>(){

                @Override
                public boolean matches(VisualSearchResult item) {
                    VisualSearchResult parent = item.getSimilarityParent();
                    boolean parentHidden = parent != null && !BasicSearchResultsModel.this.isFilterMatch(parent);
                    return item.isVisible() || parentHidden;
                }
            };
        }

        public void update() {
            this.fireChangedMatcher(new MatcherEditor.Event<VisualSearchResult>(this, 4, this.currentMatcher));
        }
    }
}

