/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.model;

import java.util.Comparator;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.ui.swing.search.model.SimilarResultsGroupingComparator;
import org.limewire.ui.swing.search.model.SimilarResultsGroupingDelegateComparator;
import org.limewire.ui.swing.search.model.SortOption;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.util.Objects;

public class SortFactory {
    public static Comparator<VisualSearchResult> getSortComparator(SortOption sortOption) {
        switch (sortOption) {
            case ALBUM: {
                return SortFactory.getStringPropertyPlusNameComparator(FilePropertyKey.ALBUM, true);
            }
            case ARTIST: {
                return SortFactory.getStringPropertyPlusNameComparator(FilePropertyKey.AUTHOR, true);
            }
            case COMPANY: {
                return SortFactory.getStringPropertyPlusNameComparator(FilePropertyKey.COMPANY, true);
            }
            case DATE_CREATED: {
                return new SimilarResultsGroupingDelegateComparator(SortFactory.getDateComparator(FilePropertyKey.DATE_CREATED, false), SortFactory.getNameComparator(true));
            }
            case FILE_EXTENSION: 
            case TYPE: {
                return new SimilarResultsGroupingComparator(){
                    private Comparator<VisualSearchResult> nameComparator = SortFactory.getNameComparator(true);

                    @Override
                    public int doCompare(VisualSearchResult vsr1, VisualSearchResult vsr2) {
                        int compare = Objects.compareToNull(vsr1.getFileExtension(), vsr2.getFileExtension());
                        if (compare == 0) {
                            compare = this.nameComparator.compare(vsr1, vsr2);
                        }
                        return compare;
                    }
                };
            }
            case CATEGORY: {
                return new SimilarResultsGroupingComparator(){
                    private Comparator<VisualSearchResult> nameComparator = SortFactory.getNameComparator(true);

                    @Override
                    public int doCompare(VisualSearchResult vsr1, VisualSearchResult vsr2) {
                        int compare = Objects.compareToNull(vsr1.getCategory(), vsr2.getCategory());
                        if (compare == 0) {
                            compare = this.nameComparator.compare(vsr1, vsr2);
                        }
                        return compare;
                    }
                };
            }
            case LENGTH: {
                return new SimilarResultsGroupingDelegateComparator(SortFactory.getLongComparator(FilePropertyKey.LENGTH, false), SortFactory.getNameComparator(true));
            }
            case NAME: 
            case TITLE: {
                return new SimilarResultsGroupingDelegateComparator(SortFactory.getNameComparator(true));
            }
            case PLATFORM: {
                return SortFactory.getStringPropertyPlusNameComparator(FilePropertyKey.COMPANY, true);
            }
            case QUALITY: {
                return new SimilarResultsGroupingDelegateComparator(SortFactory.getLongComparator(FilePropertyKey.QUALITY, false), SortFactory.getNameComparator(true));
            }
            case RELEVANCE_ITEM: {
                return SortFactory.getRelevanceComparator();
            }
            case SIZE_HIGH_TO_LOW: {
                return new SimilarResultsGroupingComparator(){
                    private Comparator<VisualSearchResult> nameComparator = SortFactory.getNameComparator(true);

                    @Override
                    public int doCompare(VisualSearchResult vsr1, VisualSearchResult vsr2) {
                        int compare = Objects.compareToNull(vsr2.getSize(), vsr1.getSize(), false);
                        if (compare == 0) {
                            compare = this.nameComparator.compare(vsr1, vsr2);
                        }
                        return compare;
                    }
                };
            }
            case SIZE_LOW_TO_HIGH: {
                return new SimilarResultsGroupingComparator(){
                    private Comparator<VisualSearchResult> nameComparator = SortFactory.getNameComparator(true);

                    @Override
                    public int doCompare(VisualSearchResult vsr1, VisualSearchResult vsr2) {
                        int compare = Objects.compareToNull(vsr1.getSize(), vsr2.getSize(), false);
                        if (compare == 0) {
                            compare = this.nameComparator.compare(vsr1, vsr2);
                        }
                        return compare;
                    }
                };
            }
            case YEAR: {
                return new SimilarResultsGroupingComparator(){
                    private Comparator<VisualSearchResult> nameComparator = SortFactory.getNameComparator(true);
                    private Comparator<VisualSearchResult> propertyComparator = SortFactory.getLongComparator(FilePropertyKey.YEAR, true);

                    @Override
                    public int doCompare(VisualSearchResult vsr1, VisualSearchResult vsr2) {
                        int compare = this.propertyComparator.compare(vsr1, vsr2);
                        if (compare == 0) {
                            compare = this.nameComparator.compare(vsr1, vsr2);
                        }
                        return compare;
                    }
                };
            }
        }
        throw new IllegalArgumentException("unknown item " + (Object)((Object)sortOption));
    }

    static Comparator<VisualSearchResult> getDateComparator(final FilePropertyKey key, final boolean ascending) {
        return new Comparator<VisualSearchResult>(){

            @Override
            public int compare(VisualSearchResult vsr1, VisualSearchResult vsr2) {
                Long v1 = (Long)vsr1.getProperty(key);
                Long v2 = (Long)vsr2.getProperty(key);
                return SortFactory.compareNullCheck(v1, v2, ascending, true);
            }
        };
    }

    static Comparator<VisualSearchResult> getLongComparator(final FilePropertyKey key, final boolean ascending) {
        return new Comparator<VisualSearchResult>(){

            @Override
            public int compare(VisualSearchResult vsr1, VisualSearchResult vsr2) {
                Long l1 = (Long)vsr1.getProperty(key);
                Long l2 = (Long)vsr2.getProperty(key);
                return SortFactory.compareNullCheck(l1, l2, ascending, true);
            }
        };
    }

    static Comparator<VisualSearchResult> getNameComparator(final boolean ascending) {
        return new Comparator<VisualSearchResult>(){

            @Override
            public int compare(VisualSearchResult vsr1, VisualSearchResult vsr2) {
                String v1 = vsr1.getHeading();
                String v2 = vsr2.getHeading();
                return ascending ? Objects.compareToNullIgnoreCase(v1, v2, false) : Objects.compareToNullIgnoreCase(v2, v1, false);
            }
        };
    }

    static Comparator<VisualSearchResult> getRelevanceComparator() {
        return new SimilarResultsGroupingDelegateComparator(SortFactory.getRelevanceComparator(false), SortFactory.getNameComparator(true));
    }

    static Comparator<VisualSearchResult> getRelevanceComparator(final boolean ascending) {
        return new Comparator<VisualSearchResult>(){

            @Override
            public int compare(VisualSearchResult vsr1, VisualSearchResult vsr2) {
                float r1 = vsr1.getRelevance();
                float r2 = vsr2.getRelevance();
                return ascending ? Objects.compareToNull(Float.valueOf(r1), Float.valueOf(r2), false) : Objects.compareToNull(Float.valueOf(r2), Float.valueOf(r1), false);
            }
        };
    }

    static Comparator<VisualSearchResult> getStringComparator(final FilePropertyKey key, final boolean ascending) {
        return new Comparator<VisualSearchResult>(){

            @Override
            public int compare(VisualSearchResult vsr1, VisualSearchResult vsr2) {
                String v1 = (String)vsr1.getProperty(key);
                String v2 = (String)vsr2.getProperty(key);
                return ascending ? Objects.compareToNullIgnoreCase(v1, v2, false) : Objects.compareToNullIgnoreCase(v2, v1, false);
            }
        };
    }

    static Comparator<VisualSearchResult> getStringPropertyPlusNameComparator(FilePropertyKey filePropertyKey, boolean ascending) {
        return new SimilarResultsGroupingDelegateComparator(SortFactory.getStringComparator(filePropertyKey, ascending), SortFactory.getNameComparator(ascending));
    }

    private static int compareNullCheck(Comparable c1, Comparable c2, boolean ascending, boolean nullsFirst) {
        return ascending ? Objects.compareToNull(c1, c2, nullsFirst) : Objects.compareToNull(c2, c1, nullsFirst);
    }
}

