/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.model;

import org.limewire.core.api.spam.SpamManager;
import org.limewire.ui.swing.search.model.SimilarResultsDetector;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.model.VisualSearchResultStatusListener;

class SpamListEventListener
implements VisualSearchResultStatusListener {
    private final SpamManager spamManager;
    private final SimilarResultsDetector similarResultsDetector;

    public SpamListEventListener(SpamManager spamManager, SimilarResultsDetector similarResultsDetector) {
        this.spamManager = spamManager;
        this.similarResultsDetector = similarResultsDetector;
    }

    @Override
    public void resultCreated(VisualSearchResult vsr) {
    }

    @Override
    public void resultsCleared() {
    }

    @Override
    public void resultChanged(VisualSearchResult visualSearchResult, String propertyName, Object oldValue, Object newValue) {
        boolean newSpam;
        boolean oldSpam;
        if ("spam-ui".equals(propertyName)) {
            boolean newSpam2;
            boolean oldSpam2 = (Boolean)oldValue;
            if (oldSpam2 != (newSpam2 = ((Boolean)newValue).booleanValue())) {
                this.spamChanged(visualSearchResult, newSpam2, true);
            }
        } else if ("spam-core".equals(propertyName) && (oldSpam = ((Boolean)oldValue).booleanValue()) != (newSpam = ((Boolean)newValue).booleanValue())) {
            this.spamChanged(visualSearchResult, newSpam, false);
        }
    }

    private void spamChanged(VisualSearchResult visualSearchResult, boolean newSpam, boolean fromUI) {
        if (newSpam) {
            if (fromUI) {
                this.spamManager.handleUserMarkedSpam(visualSearchResult.getCoreSearchResults());
            }
            VisualSearchResult parent = visualSearchResult.getSimilarityParent();
            VisualSearchResult newParent = null;
            if (parent == null) {
                newParent = this.pickNewParent(visualSearchResult);
            } else {
                this.removeItemFromParent(visualSearchResult, parent);
            }
            this.similarResultsDetector.removeSpamItem(visualSearchResult, newParent);
        } else {
            if (fromUI) {
                this.spamManager.handleUserMarkedGood(visualSearchResult.getCoreSearchResults());
            }
            this.similarResultsDetector.detectSimilarResult(visualSearchResult);
        }
    }

    private void removeItemFromParent(VisualSearchResult visualSearchResult, VisualSearchResult parent) {
        parent.removeSimilarSearchResult(visualSearchResult);
        visualSearchResult.setSimilarityParent(null);
        visualSearchResult.setChildrenVisible(false);
        visualSearchResult.setVisible(true);
    }

    private VisualSearchResult pickNewParent(VisualSearchResult visualSearchResult) {
        VisualSearchResult newParent = null;
        if (visualSearchResult.getSimilarResults().size() > 0) {
            newParent = visualSearchResult.getSimilarResults().get(0);
            newParent.setSimilarityParent(null);
            visualSearchResult.removeSimilarSearchResult(newParent);
        }
        for (VisualSearchResult simResult : visualSearchResult.getSimilarResults()) {
            visualSearchResult.removeSimilarSearchResult(simResult);
            if (newParent != null) {
                newParent.addSimilarSearchResult(simResult);
            }
            simResult.setSimilarityParent(newParent);
        }
        if (newParent != null) {
            newParent.setChildrenVisible(visualSearchResult.isChildrenVisible());
            newParent.setVisible(true);
        }
        visualSearchResult.setChildrenVisible(false);
        visualSearchResult.setVisible(false);
        visualSearchResult.setVisible(true);
        return newParent;
    }
}

