/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.limewire.ui.swing.downloads.DownloadMediator;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.search.model.SearchResultsModel;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.DownloadHandler;
import org.limewire.ui.swing.search.resultpanel.DownloadPreprocessor;
import org.limewire.ui.swing.search.resultpanel.LicenseWarningDownloadPreprocessor;

class DownloadHandlerImpl
implements DownloadHandler {
    private final SearchResultsModel searchResultsModel;
    private List<DownloadPreprocessor> downloadPreprocessors = new ArrayList<DownloadPreprocessor>();
    private LibraryMediator libraryMediator;
    private final DownloadMediator downloadMediator;

    public DownloadHandlerImpl(SearchResultsModel searchResultsModel, LibraryMediator libraryMediator, DownloadMediator downloadMediator) {
        this.searchResultsModel = searchResultsModel;
        this.libraryMediator = libraryMediator;
        this.downloadMediator = downloadMediator;
        this.downloadPreprocessors.add(new LicenseWarningDownloadPreprocessor());
    }

    @Override
    public void download(VisualSearchResult vsr) {
        this.download(vsr, null);
    }

    @Override
    public void download(VisualSearchResult vsr, File saveFile) {
        if (this.maybeNavigate(vsr)) {
            return;
        }
        for (DownloadPreprocessor preprocessor : this.downloadPreprocessors) {
            boolean shouldDownload = preprocessor.execute(vsr);
            if (shouldDownload) continue;
            return;
        }
        this.searchResultsModel.download(vsr, saveFile);
    }

    private boolean maybeNavigate(VisualSearchResult vsr) {
        switch (vsr.getDownloadState()) {
            case DOWNLOADING: 
            case REMOVED: {
                this.downloadMediator.selectAndScrollTo(vsr.getUrn());
                return true;
            }
            case DOWNLOADED: 
            case LIBRARY: {
                this.libraryMediator.selectInLibrary(vsr.getUrn());
                return true;
            }
        }
        return false;
    }
}

