/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel.classic;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.ResultsTableFormat;
import org.limewire.ui.swing.settings.TablesHandler;
import org.limewire.ui.swing.table.ColumnStateInfo;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.IconManager;

public class DocumentTableFormat
extends ResultsTableFormat<VisualSearchResult> {
    static final int FROM_INDEX = 0;
    static final int NAME_INDEX = 1;
    static final int TYPE_INDEX = 2;
    static final int EXTENSION_INDEX = 3;
    public static final int SIZE_INDEX = 4;
    static final int DATE_INDEX = 5;
    static final int AUTHOR_INDEX = 6;
    static final int DESCRIPTION_INDEX = 7;
    static final int IS_SPAM_INDEX = 8;
    private final Provider<IconManager> iconManager;

    @Inject
    public DocumentTableFormat(Provider<IconManager> iconManager) {
        super("CLASSIC_SEARCH_DOCUMENT_TABLE", 1, 0, 8, new ColumnStateInfo(0, "CLASSIC_SEARCH_DOCUMENT_FROM", I18n.tr("From"), 88, true, true), new ColumnStateInfo(1, "CLASSIC_SEARCH_DOCUMENT_NAME", I18n.tr("Name"), 493, true, true), new ColumnStateInfo(2, "CLASSIC_SEARCH_DOCUMENT_TYPE", I18n.tr("Type"), 180, true, true), new ColumnStateInfo(3, "CLASSIC_SEARCH_DOCUMENT_EXTENSION", I18n.tr("Extension"), 83, true, true), new ColumnStateInfo(4, "CLASSIC_SEARCH_DOCUMENT_SIZE", I18n.tr("Size"), 92, true, true), new ColumnStateInfo(5, "CLASSIC_SEARCH_DOCUMENT_DATE", I18n.tr("Date Created"), 104, false, true), new ColumnStateInfo(6, "CLASSIC_SEARCH_DOCUMENT_AUTHOR", I18n.tr("Author"), 80, false, true), new ColumnStateInfo(7, "CLASSIC_SEARCH_DOCUMENT_DESCRIPTION", I18n.tr("Description"), 80, false, true), new ColumnStateInfo(8, "CLASSIC_SEARCH_DOCUMENT_IS_SPAM", "", 10, false, false));
        this.iconManager = iconManager;
    }

    @Override
    public Class getColumnClass(int column) {
        switch (column) {
            case 1: {
                return Component.class;
            }
            case 5: {
                return Calendar.class;
            }
            case 4: {
                return Integer.class;
            }
            case 0: {
                return VisualSearchResult.class;
            }
        }
        return super.getColumnClass(column);
    }

    @Override
    public Object getColumnValue(VisualSearchResult vsr, int column) {
        switch (column) {
            case 1: {
                return vsr;
            }
            case 2: {
                return this.iconManager != null ? this.iconManager.get().getMIMEDescription(vsr.getFileExtension()) : vsr.getFileExtension();
            }
            case 4: {
                return vsr.getSize();
            }
            case 5: {
                return vsr.getProperty(FilePropertyKey.DATE_CREATED);
            }
            case 0: {
                return vsr;
            }
            case 3: {
                return vsr.getFileExtension();
            }
            case 6: {
                return vsr.getProperty(FilePropertyKey.AUTHOR);
            }
            case 7: {
                return "";
            }
            case 8: {
                return vsr;
            }
        }
        throw new IllegalArgumentException("Unknown column:" + column);
    }

    @Override
    public List<SortKey> getDefaultSortKeys() {
        if (TablesHandler.getSortedColumn(this.getSortOrderID(), this.getSortedColumn()).getValue() == this.getSortedColumn() && TablesHandler.getSortedOrder(this.getSortOrderID(), this.getSortOrder()).getValue() == this.getSortOrder()) {
            return Arrays.asList(new SortKey(SortOrder.DESCENDING, 0), new SortKey(SortOrder.ASCENDING, 1), new SortKey(SortOrder.ASCENDING, 2), new SortKey(SortOrder.ASCENDING, 4));
        }
        return super.getDefaultSortKeys();
    }

    @Override
    public List<Integer> getSecondarySortColumns(int column) {
        switch (column) {
            case 1: {
                return Arrays.asList(2, 4);
            }
            case 2: {
                return Arrays.asList(1, 4);
            }
            case 4: {
                return Arrays.asList(1, 2);
            }
        }
        return Collections.emptyList();
    }
}

