/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.statusbar;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.limewire.core.api.library.FileProcessingEvent;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.listener.EventListener;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.components.decorators.ButtonDecorator;
import org.limewire.ui.swing.painter.StatusBarPopupButtonPainter;
import org.limewire.ui.swing.statusbar.FileProcessingPopupPanel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.PainterUtils;

@Singleton
class FileProcessingPanel
extends JXButton {
    @Resource
    private Color activeBackground = PainterUtils.TRASPARENT;
    @Resource
    private Color activeBorder = PainterUtils.TRASPARENT;
    @Resource
    private Font font;
    @Resource
    private Color foreground;
    private int total;
    private int finished;
    private FileProcessingPopupPanel popup;

    @Inject
    FileProcessingPanel(ButtonDecorator decorator, final FileProcessingPopupPanel popup) {
        GuiUtils.assignResources(this);
        this.setFont(this.font);
        this.setForeground(this.foreground);
        decorator.decorateStatusPopupButton(this, new StatusBarPopupButtonPainter.PopupVisibilityChecker(){

            @Override
            public boolean isPopupVisible() {
                return popup != null ? popup.isVisible() : false;
            }
        }, this.activeBackground, this.activeBorder, StatusBarPopupButtonPainter.DrawMode.NORMAL);
        this.popup = popup;
        popup.registerParent(this);
        popup.setVisible(false);
        this.setVisible(false);
    }

    @Inject
    void registerListeners(LibraryManager libraryManager) {
        libraryManager.getLibraryManagedList().addFileProcessingListener(new EventListener<FileProcessingEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FileProcessingEvent event) {
                switch ((FileProcessingEvent.Type)((Object)event.getType())) {
                    case QUEUED: {
                        FileProcessingPanel.this.total++;
                        FileProcessingPanel.this.update();
                        break;
                    }
                    case FINISHED: {
                        FileProcessingPanel.this.finished++;
                        if (FileProcessingPanel.this.finished == FileProcessingPanel.this.total) {
                            FileProcessingPanel.this.finished = 0;
                            FileProcessingPanel.this.total = 0;
                        }
                        FileProcessingPanel.this.update();
                    }
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileProcessingPanel.this.popup.setVisible(true);
            }
        });
        this.popup.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                FileProcessingPanel.this.repaint();
                FileProcessingPanel.this.closePopup();
            }
        });
    }

    private void closePopup() {
        this.setVisible(this.total != 0);
    }

    private void update() {
        if (this.total == 0) {
            if (this.popup.isVisible()) {
                this.setText(I18n.tr("Done"));
                this.popup.notifyDone();
            } else {
                this.setVisible(false);
            }
        } else {
            this.setText(I18n.tr("Adding {0} of {1}", this.finished + 1, this.total));
            this.setVisible(true);
        }
    }
}

