/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.upload.table;

import com.google.inject.Inject;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.player.PlayerUtils;
import org.limewire.ui.swing.properties.FileInfoDialog;
import org.limewire.ui.swing.properties.FileInfoDialogFactory;
import org.limewire.ui.swing.upload.UploadMediator;
import org.limewire.ui.swing.util.NativeLaunchUtils;

class UploadActionHandler {
    public static final String PLAY_COMMAND = "play";
    public static final String PAUSE_COMMAND = "pause";
    public static final String RESUME_COMMAND = "resume";
    public static final String CANCEL_COMMAND = "cancel";
    public static final String LIBRARY_COMMAND = "library";
    public static final String LAUNCH_COMMAND = "launch";
    public static final String REMOVE_COMMAND = "remove";
    public static final String LOCATE_ON_DISK_COMMAND = "locate";
    public static final String PROPERTIES_COMMAND = "properties";
    private final UploadMediator uploadMediator;
    private final FileInfoDialogFactory fileInfoFactory;
    private final LibraryMediator libraryMediator;
    private final CategoryManager categoryManager;

    @Inject
    UploadActionHandler(UploadMediator uploadMediator, LibraryMediator libraryMediator, FileInfoDialogFactory fileInfoFactory, CategoryManager categoryManager) {
        this.uploadMediator = uploadMediator;
        this.libraryMediator = libraryMediator;
        this.fileInfoFactory = fileInfoFactory;
        this.categoryManager = categoryManager;
    }

    public void performAction(String actionCommmand, UploadItem item) {
        if (actionCommmand == CANCEL_COMMAND) {
            this.uploadMediator.cancel(item, true);
        } else if (actionCommmand == LOCATE_ON_DISK_COMMAND) {
            NativeLaunchUtils.launchExplorer(item.getFile());
        } else if (actionCommmand == PROPERTIES_COMMAND) {
            FileInfoDialog dialog = this.fileInfoFactory.createFileInfoDialog(item, FileInfoDialog.FileInfoType.UPLOADING_FILE);
            dialog.setVisible(true);
        } else if (actionCommmand == REMOVE_COMMAND) {
            this.uploadMediator.remove(item);
        } else if (actionCommmand == LIBRARY_COMMAND) {
            this.libraryMediator.selectInLibrary(item.getFile());
        } else if (actionCommmand == LAUNCH_COMMAND) {
            PlayerUtils.playOrLaunch(item.getFile(), this.categoryManager);
        } else if (actionCommmand == PLAY_COMMAND) {
            PlayerUtils.playOrLaunch(item.getFile(), this.categoryManager);
        } else if (actionCommmand == PAUSE_COMMAND) {
            item.pause();
        } else if (actionCommmand == RESUME_COMMAND) {
            item.resume();
        }
    }
}

