/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.text.html.StyleSheet;

public class FontUtils {
    private FontUtils() {
    }

    public static void changeSize(JComponent component, float increment) {
        Font font = component.getFont();
        if (font == null) {
            return;
        }
        float newSize = (float)font.getSize() + increment;
        component.setFont(font.deriveFont(newSize));
    }

    public static void setSize(JComponent component, int size) {
        Font font = component.getFont();
        if (font == null) {
            return;
        }
        component.setFont(font.deriveFont((float)size));
    }

    public static void changeStyle(JComponent component, int style) {
        component.setFont(component.getFont().deriveFont(style));
    }

    public static void bold(JComponent component) {
        FontUtils.changeStyle(component, 1);
    }

    public static void plain(JComponent component) {
        FontUtils.changeStyle(component, 0);
    }

    public static void underline(JComponent component) {
        Font font = component.getFont();
        if (font != null) {
            component.setFont(FontUtils.deriveUnderline(font, true));
        }
    }

    public static boolean isUnderlined(JComponent component) {
        Font font = component.getFont();
        if (font != null) {
            Map<TextAttribute, ?> map = font.getAttributes();
            return map.get(TextAttribute.UNDERLINE) == TextAttribute.UNDERLINE_ON;
        }
        return false;
    }

    public static void removeUnderline(JComponent component) {
        Font font = component.getFont();
        if (font != null) {
            component.setFont(FontUtils.deriveUnderline(font, false));
        }
    }

    public static Font deriveUnderline(Font font, boolean underlined) {
        Map<TextAttribute, ?> map = font.getAttributes();
        HashMap newMap = new HashMap(map);
        newMap.put(TextAttribute.UNDERLINE, underlined ? TextAttribute.UNDERLINE_ON : Integer.valueOf(-1));
        return font.deriveFont(newMap);
    }

    public static boolean canDisplay(Font f, String s) {
        int upTo = f.canDisplayUpTo(s);
        return upTo >= s.length() || upTo == -1;
    }

    private static String unpackText(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Action) {
            return (String)((Action)object).getValue("Name");
        }
        return object.toString();
    }

    public static Rectangle2D getLongestTextArea(Font font, Object ... objects) {
        FontRenderContext frc = new FontRenderContext(null, false, false);
        Rectangle2D largestRect = new Rectangle();
        for (int i = 0; i < objects.length; ++i) {
            Icon icon;
            Object obj = objects[i];
            Rectangle2D currentRect = font.getStringBounds(FontUtils.unpackText(obj), frc);
            if (obj instanceof Action && (icon = (Icon)((Action)obj).getValue("SmallIcon")) != null) {
                currentRect.setRect(currentRect.getX(), currentRect.getY(), currentRect.getWidth() + (double)icon.getIconWidth() + 10.0, currentRect.getHeight());
            }
            if (!(currentRect.getWidth() > ((RectangularShape)largestRect).getWidth())) continue;
            largestRect = currentRect;
        }
        return largestRect;
    }

    public static String getTruncatedMessage(String message, Font font, int maxWidth) {
        String ELIPSES = "...";
        while (FontUtils.getPixelWidth(message, font) > maxWidth) {
            message = message.substring(0, message.length() - (ELIPSES.length() + 1)) + ELIPSES;
        }
        return message;
    }

    public static int getPixelWidth(String text, Font font) {
        StyleSheet css = new StyleSheet();
        FontMetrics fontMetrics = css.getFontMetrics(font);
        return fontMetrics.stringWidth(text);
    }
}

