/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenericsUtils {
    private GenericsUtils() {
    }

    public static <K, V extends List, T> Map<K, List<T>> scanForMapOfList(Object o, Class<K> k, Class<V> v, Class<T> t, ScanMode mode) {
        Map<K, Collection<T>> map = GenericsUtils.scanForMapOfCollection(o, k, v, t, mode);
        return map;
    }

    public static <K, V extends Collection, T> Map<K, Collection<T>> scanForMapOfCollection(Object o, Class<K> k, Class<V> v, Class<T> t, ScanMode mode) {
        if (mode == ScanMode.NEW_COPY_REMOVED) {
            throw new IllegalArgumentException((Object)((Object)ScanMode.NEW_COPY_REMOVED) + " is not supported");
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null || !k.isAssignableFrom(key.getClass()) || !v.isAssignableFrom(value.getClass())) {
                    switch (mode) {
                        case EXCEPTION: {
                            StringBuilder errorReport = new StringBuilder();
                            if (key == null) {
                                errorReport.append("key is null ");
                            } else if (!k.isAssignableFrom(key.getClass())) {
                                errorReport.append("key class not assignable ").append(key.getClass()).append(" to ").append(k);
                            }
                            if (value == null) {
                                errorReport.append("value is null for key ").append(key);
                            } else if (!v.isAssignableFrom(value.getClass())) {
                                errorReport.append("value class not assignable ").append(value.getClass()).append(" to ").append(v);
                            }
                            throw new ClassCastException(errorReport.toString());
                        }
                        case REMOVE: {
                            i.remove();
                        }
                    }
                    continue;
                }
                GenericsUtils.scanForCollection(value, t, mode);
            }
            return map;
        }
        throw new ClassCastException();
    }

    public static <K, V> Map<K, V> scanForMap(Object o, Class<K> k, Class<V> v, ScanMode mode) {
        if (mode == ScanMode.NEW_COPY_REMOVED) {
            throw new IllegalArgumentException("must use scanForMap(Object, Class, Class, ScanMode, Class");
        }
        return GenericsUtils.scanForMap(o, k, v, mode, null);
    }

    public static <K, V> Map<K, V> scanForMap(Object o, Class<K> k, Class<V> v, ScanMode mode, Class<? extends Map<K, V>> createFromThis) {
        if (o instanceof Map) {
            Map map = (Map)o;
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key != null && value != null && k.isAssignableFrom(key.getClass()) && v.isAssignableFrom(value.getClass())) continue;
                switch (mode) {
                    case EXCEPTION: {
                        StringBuilder errorReport = new StringBuilder();
                        if (key == null) {
                            errorReport.append("key is null ");
                        } else if (!k.isAssignableFrom(key.getClass())) {
                            errorReport.append("key class not assignable ").append(key.getClass()).append(" to ").append(k);
                        }
                        if (value == null) {
                            errorReport.append("value is null for key ").append(key);
                        } else if (!v.isAssignableFrom(value.getClass())) {
                            errorReport.append("value class not assignable ").append(value.getClass()).append(" to ").append(v);
                        }
                        throw new ClassCastException(errorReport.toString());
                    }
                    case REMOVE: {
                        i.remove();
                        break;
                    }
                    case NEW_COPY_REMOVED: {
                        return GenericsUtils.copyAndFilterMap(GenericsUtils.newMap(createFromThis), map, k, v);
                    }
                }
            }
            return map;
        }
        throw new ClassCastException();
    }

    public static <V> Collection<V> scanForCollection(Object o, Class<V> v, ScanMode mode) {
        if (mode == ScanMode.NEW_COPY_REMOVED) {
            throw new IllegalArgumentException("must use scanForCollection(Object, Class, ScanMode, Class");
        }
        return GenericsUtils.scanForCollection(o, v, mode, null);
    }

    public static <V> Collection<V> scanForCollection(Object o, Class<V> v, ScanMode mode, Class<? extends Collection<V>> createFromThis) {
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            Iterator i = c.iterator();
            while (i.hasNext()) {
                Object value = i.next();
                if (value != null && v.isAssignableFrom(value.getClass())) continue;
                switch (mode) {
                    case EXCEPTION: {
                        throw new ClassCastException("wanted an instanceof: " + v + ", but was: [" + value + "] of type: " + (value == null ? "null" : value.getClass().getName()));
                    }
                    case REMOVE: {
                        i.remove();
                        break;
                    }
                    case NEW_COPY_REMOVED: {
                        return GenericsUtils.copyAndFilterCollection(GenericsUtils.newCollection(createFromThis), c, v);
                    }
                }
            }
            return c;
        }
        throw new ClassCastException();
    }

    public static <V> Set<V> scanForSet(Object o, Class<V> v, ScanMode mode) {
        if (mode == ScanMode.NEW_COPY_REMOVED) {
            throw new IllegalArgumentException("must use scanForSet(Object, Class, ScanMode, Class");
        }
        return GenericsUtils.scanForSet(o, v, mode, null);
    }

    public static <V> Set<V> scanForSet(Object o, Class<V> v, ScanMode mode, Class<? extends Set<V>> createFromThis) {
        if (o instanceof Set) {
            return (Set)GenericsUtils.scanForCollection(o, v, mode, createFromThis);
        }
        throw new ClassCastException();
    }

    public static <V> List<V> scanForList(Object o, Class<V> v, ScanMode mode) {
        if (mode == ScanMode.NEW_COPY_REMOVED) {
            throw new IllegalArgumentException("must use scanForList(Object, Class, ScanMode, Class");
        }
        return GenericsUtils.scanForList(o, v, mode, null);
    }

    public static <V> List<V> scanForList(Object o, Class<V> v, ScanMode mode, Class<? extends List<V>> createFromThis) {
        if (o instanceof List) {
            return (List)GenericsUtils.scanForCollection(o, v, mode, createFromThis);
        }
        throw new ClassCastException();
    }

    private static <K, V> Map<K, V> copyAndFilterMap(Map<K, V> copy, Map original, Class<K> k, Class<V> v) {
        for (Map.Entry entry : original.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null || !k.isAssignableFrom(key.getClass()) || !v.isAssignableFrom(value.getClass())) continue;
            copy.put(key, value);
        }
        return copy;
    }

    private static <V> Collection<V> copyAndFilterCollection(Collection<V> copy, Collection original, Class<V> v) {
        for (Object value : original) {
            if (value == null || !v.isAssignableFrom(value.getClass())) continue;
            copy.add(value);
        }
        return copy;
    }

    private static <V, T extends Collection<V>> T newCollection(Class<? extends T> creator) {
        try {
            return (T)((Collection)creator.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static <K, V, T extends Map<K, V>> T newMap(Class<? extends T> creator) {
        try {
            return (T)((Map)creator.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum ScanMode {
        EXCEPTION,
        REMOVE,
        NEW_COPY_REMOVED;

    }
}

