/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;

public class URIUtils {
    private static final String URI_DECODE_RESERVED = ";/?:@&=+$,#";

    public static URI toURI(String uriString) throws URISyntaxException {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            String encodedURIString = URIUtils.encodeUri(uriString);
            try {
                uri = new URI(encodedURIString);
            }
            catch (URISyntaxException e1) {
                if (e.getCause() == null) {
                    e.initCause(e1);
                }
                throw e;
            }
        }
        return uri;
    }

    public static int getPort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            String scheme = uri.getScheme();
            if ("http".equalsIgnoreCase(scheme)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(scheme)) {
                port = 443;
            }
        }
        return port;
    }

    public static String encodeUri(String uri) throws URISyntaxException {
        return URIUtils.encode(uri, true);
    }

    public static String encodeUriComponent(String uriComponent) throws URISyntaxException {
        return URIUtils.encode(uriComponent, false);
    }

    public static String decodeToUtf8(String uri) throws URISyntaxException {
        try {
            return URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException iae) {
            throw new URISyntaxException(uri, "invalid url");
        }
    }

    private static String encode(String str, boolean fullUri) throws URISyntaxException {
        byte[] utf8buf = null;
        StringBuilder sb = null;
        int length = str.length();
        for (int k = 0; k != length; ++k) {
            int value;
            int c = str.charAt(k);
            if (URIUtils.encodeUnescaped((char)c, fullUri)) {
                if (sb == null) continue;
                sb.append((char)c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(length + 3);
                sb.append(str);
                sb.setLength(k);
                utf8buf = new byte[6];
            }
            if (56320 <= c && c <= 57343) {
                throw new URISyntaxException(str, (char)c + " outside of valid range");
            }
            if (c < 55296 || 56319 < c) {
                value = c;
            } else {
                if (++k == length) {
                    throw new URISyntaxException(str, "out of chars");
                }
                char c2 = str.charAt(k);
                if ('\udc00' > c2 || c2 > '\udfff') {
                    throw new URISyntaxException(str, "outside of valid range");
                }
                value = (c - 55296 << 10) + (c2 - 56320) + 65536;
            }
            int L = URIUtils.oneUcs4ToUtf8Char(utf8buf, value);
            assert (utf8buf != null);
            for (int j = 0; j < L; ++j) {
                int d = 0xFF & utf8buf[j];
                sb.append('%');
                sb.append(URIUtils.toHexChar(d >>> 4));
                sb.append(URIUtils.toHexChar(d & 0xF));
            }
        }
        return sb == null ? str : sb.toString();
    }

    private static char toHexChar(int i) {
        if (i >> 4 != 0) {
            throw new RuntimeException();
        }
        return (char)(i < 10 ? i + 48 : i - 10 + 97);
    }

    private static boolean encodeUnescaped(char c, boolean fullUri) {
        if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9') {
            return true;
        }
        if ("-_.!~*'()".indexOf(c) >= 0) {
            return true;
        }
        if (fullUri) {
            return URI_DECODE_RESERVED.indexOf(c) >= 0;
        }
        return false;
    }

    private static int oneUcs4ToUtf8Char(byte[] utf8Buffer, int ucs4Char) {
        int utf8Length = 1;
        if ((ucs4Char & 0xFFFFFF80) == 0) {
            utf8Buffer[0] = (byte)ucs4Char;
        } else {
            int a = ucs4Char >>> 11;
            utf8Length = 2;
            while (a != 0) {
                a >>>= 5;
                ++utf8Length;
            }
            int i = utf8Length;
            while (--i > 0) {
                utf8Buffer[i] = (byte)(ucs4Char & 0x3F | 0x80);
                ucs4Char >>>= 6;
            }
            utf8Buffer[0] = (byte)(256 - (1 << 8 - utf8Length) + ucs4Char);
        }
        return utf8Length;
    }
}

