/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl.messages.authtoken;

import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.jivesoftware.smack.packet.IQ;
import org.limewire.friend.api.feature.AuthToken;
import org.limewire.friend.impl.feature.AuthTokenImpl;
import org.limewire.util.Objects;
import org.limewire.util.StringUtils;
import org.limewire.xmpp.client.impl.messages.InvalidIQException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AuthTokenIQ
extends IQ {
    private AuthToken authToken;

    public AuthTokenIQ(XmlPullParser parser) throws IOException, XmlPullParserException, InvalidIQException {
        do {
            int eventType;
            if ((eventType = parser.getEventType()) == 2) {
                if (!parser.getName().equals("token")) continue;
                String value = parser.getAttributeValue(null, "value");
                if (value == null) {
                    throw new InvalidIQException("no value");
                }
                this.authToken = new AuthTokenImpl(value);
                continue;
            }
            if (eventType == 3 && parser.getName().equals("auth-token")) break;
        } while (parser.nextTag() != 1);
        if (this.authToken == null) {
            throw new InvalidIQException("no auth token parsed");
        }
    }

    public AuthTokenIQ(AuthToken authToken) {
        this.authToken = Objects.nonNull(authToken, "authToken");
    }

    public AuthToken getAuthToken() {
        return this.authToken;
    }

    @Override
    public String getChildElementXML() {
        StringBuilder authTokenElement = new StringBuilder("<auth-token xmlns=\"jabber:iq:lw-auth-token\">");
        authTokenElement.append("<token value=\"").append(StringUtils.getUTF8String(Base64.encodeBase64(StringUtils.toUTF8Bytes(this.authToken.getBase64())))).append("\"/>");
        authTokenElement.append("</auth-token>");
        return authTokenElement.toString();
    }

    public String toString() {
        return this.authToken.getBase64();
    }
}

