/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser;

import java.io.File;
import java.io.IOException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.MozillaConfig;
import org.mozilla.browser.MozillaException;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaRuntimeException;
import org.mozilla.browser.RunnableEx;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.common.Platform;
import org.mozilla.browser.common.XULRunnerFinder;
import org.mozilla.browser.impl.LocationProvider;
import org.mozilla.browser.impl.WindowCreator;
import org.mozilla.browser.impl.XREAppData;
import org.mozilla.browser.impl.jna.LibC;
import org.mozilla.browser.mt;
import org.mozilla.dom.ThreadProxy;
import org.mozilla.interfaces.nsIExtensionManager;
import org.mozilla.interfaces.nsIPrefBranch;
import org.mozilla.interfaces.nsIWindowWatcher;
import org.mozilla.xpcom.Mozilla;

public class MozillaInitialization {
    static Log log = LogFactory.getLog(MozillaInitialization.class);
    private static InitStatus status = InitStatus.NONE;
    static Throwable error = null;
    static WindowCreator winCreator;

    public static void initialize() {
        if (status != InitStatus.NONE) {
            return;
        }
        Policy.setPolicy(new Policy(){

            public PermissionCollection getPermissions(CodeSource codesource) {
                Permissions perms = new Permissions();
                perms.add(new AllPermission());
                return perms;
            }

            public void refresh() {
            }
        });
        try {
            File profDir;
            File xpti;
            File xulrunnerDir = MozillaConfig.getXULRunnerHome();
            if (xulrunnerDir != null && !XULRunnerFinder.isXULRunnerDir(xulrunnerDir)) {
                log.error("invalid current xulrunner location " + xulrunnerDir.getAbsolutePath());
                log.info("Continuing to search for other xulrunners");
                xulrunnerDir = null;
            }
            if (xulrunnerDir == null) {
                xulrunnerDir = XULRunnerFinder.findXULRunner();
                MozillaConfig.setXULRunnerHome(xulrunnerDir);
            }
            if (xulrunnerDir == null) {
                throw new IOException(mt.t("MozillaInitialization.Unable_to_resolve_XULRunner_home"));
            }
            log.info("Using xul runner dir: " + xulrunnerDir.getAbsolutePath());
            final File foundXulrunnerDir = xulrunnerDir;
            File componentsDir = new File(xulrunnerDir, "components");
            File compreg = new File(componentsDir, "compreg.dat");
            if (compreg.isFile()) {
                compreg.delete();
            }
            if ((xpti = new File(componentsDir, "xpti.dat")).isFile()) {
                xpti.delete();
            }
            if (MozillaConfig.isInitializeWithProfile()) {
                if (MozillaConfig.getProfileDir() != null) {
                    profDir = MozillaConfig.getProfileDir();
                } else {
                    File f = File.createTempFile("swing-mozilla", "");
                    f.delete();
                    profDir = f;
                    profDir.mkdirs();
                    MozillaConfig.setProfileDir(profDir);
                }
            } else {
                profDir = null;
            }
            File nativeLibsDir = foundXulrunnerDir.getParentFile();
            if (Platform.platform == Platform.OSX && !new File(nativeLibsDir, "libcocoautils.jnilib").exists()) {
                log.error("Unable to resolve location of MozSwing native libraries");
                log.info("Continuing assuming java.library.path is set");
                nativeLibsDir = null;
            }
            File foundNativeLibsDir = nativeLibsDir;
            MozillaExecutor.mozInit(foundXulrunnerDir, foundNativeLibsDir, new RunnableEx(){

                public void run() throws Exception {
                    if (Platform.platform == Platform.Solaris || Platform.platform == Platform.Linux) {
                        int ret = LibC.libc.setenv("MOZ_DISABLE_SIG_HANDLER", "1", true);
                        assert (ret == 0);
                    }
                    Mozilla moz = Mozilla.getInstance();
                    moz.initialize(foundXulrunnerDir);
                    LocationProvider locProvider = new LocationProvider(foundXulrunnerDir, profDir);
                    moz.initEmbedding(foundXulrunnerDir, foundXulrunnerDir, locProvider, new XREAppData());
                    if (profDir != null) {
                        moz.lockProfileDirectory(profDir);
                        moz.notifyProfile();
                    }
                    winCreator = new WindowCreator();
                    nsIWindowWatcher winWatcher = XPCOMUtils.getService("@mozilla.org/embedcomp/window-watcher;1", nsIWindowWatcher.class);
                    winWatcher.setWindowCreator(winCreator);
                    nsIPrefBranch pref = XPCOMUtils.getService("@mozilla.org/preferences-service;1", nsIPrefBranch.class);
                    pref.setBoolPref("browser.download.useDownloadDir", 0);
                    pref.setIntPref("browser.download.folderList", 0);
                    pref.setIntPref("browser.download.manager.quitBehavior", 2);
                    pref.setIntPref("browser.download.manager.retention", 1);
                    if (Platform.platform == Platform.Win32 || Platform.platform == Platform.OSX) {
                        pref.setBoolPref("security.enable_java", 0);
                    }
                    pref.setBoolPref("browser.xul.error_pages.enabled", 1);
                    pref.setBoolPref("security.warn_entering_secure", 0);
                    pref.setBoolPref("security.warn_entering_weak", 0);
                    pref.setBoolPref("security.warn_leaving_secure", 0);
                    pref.setBoolPref("security.warn_submit_insecure", 0);
                    pref.setBoolPref("security.warn_viewing_mixed", 0);
                    nsIExtensionManager em = XPCOMUtils.getService("@mozilla.org/extensions/manager;1", nsIExtensionManager.class);
                    em.start(null);
                    ThreadProxy.setSingleton(new ThreadProxy(){

                        @Override
                        public boolean isMozillaThread() {
                            return MozillaExecutor.isMozillaThread();
                        }

                        @Override
                        public void syncExec(Runnable task) {
                            MozillaExecutor.mozSyncExec(task);
                        }

                        @Override
                        public <V> V syncExec(Callable<V> task) {
                            try {
                                return MozillaExecutor.mozSyncExec(task);
                            }
                            catch (MozillaException e) {
                                throw new MozillaRuntimeException(e);
                            }
                        }
                    });
                    status = InitStatus.INITIALIZED;
                    MozillaExecutor.runPostponedPreInitTasks();
                }
            });
        }
        catch (Exception e) {
            log.error("failed to initialize mozilla", e);
            status = InitStatus.FAILED;
            error = e;
        }
    }

    public static boolean isInitialized() {
        return status == InitStatus.INITIALIZED;
    }

    public static Throwable getError() {
        return error;
    }

    public static InitStatus getStatus() {
        return status;
    }

    public static WindowCreator getWinCreator() {
        return winCreator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InitStatus {
        NONE,
        INITIALIZED,
        FAILED;

    }
}

