/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.examples;

import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaPanel;
import org.mozilla.browser.MozillaWindow;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIDOMWindow2;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.xpcom.Mozilla;

public class Example12_BlockEvents {
    public static void main(String[] args) {
        MozillaWindow win = new MozillaWindow();
        final MozillaPanel moz = win.getPanel();
        win.setSize(500, 600);
        moz.load("about:");
        win.setVisible(true);
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                nsIWebBrowser webBrowser = moz.getChromeAdapter().getWebBrowser();
                nsIDOMWindow domWin = webBrowser.getContentDOMWindow();
                nsIDOMWindow2 domWin2 = XPCOMUtils.qi(domWin, nsIDOMWindow2.class);
                nsIDOMEventTarget et = domWin2.getWindowRoot();
                MyDOMListener l = new MyDOMListener();
                for (String ev : new String[]{"click", "mousemove", "mousedown", "mouseup", "keydown", "keyup", "keypress"}) {
                    et.addEventListener(ev, l, true);
                }
            }
        });
    }

    private static class MyDOMListener
    implements nsIDOMEventListener {
        private MyDOMListener() {
        }

        public void handleEvent(nsIDOMEvent event) {
            System.err.println("event " + event.getType());
            if (event.getCancelable()) {
                System.err.println("canceling event " + event.getType());
                event.preventDefault();
            }
            event.stopPropagation();
        }

        public nsISupports queryInterface(String uuid) {
            return Mozilla.queryInterface(this, uuid);
        }
    }
}

