/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.common.Platform;
import org.mozilla.xpcom.IAppFileLocProvider;

public class LocationProvider
implements IAppFileLocProvider {
    static Log log = LogFactory.getLog(LocationProvider.class);
    private File libXULPath;
    private File profile;
    private File history;

    public LocationProvider(File aBinPath, File aProfileDir) throws IOException {
        this.libXULPath = aBinPath;
        this.profile = aProfileDir;
        if (!this.libXULPath.exists() || !this.libXULPath.isDirectory()) {
            throw new FileNotFoundException("libxul directory specified is not valid: " + this.libXULPath.getAbsolutePath());
        }
        if (!(this.profile == null || this.profile.exists() && this.profile.isDirectory())) {
            throw new FileNotFoundException("profile directory specified is not valid: " + this.profile.getAbsolutePath());
        }
        if (this.profile != null) {
            this.setupProfile();
        }
    }

    private void setupProfile() throws IOException {
        this.history = new File(this.profile, "history.dat");
        if (!this.history.exists()) {
            this.history.createNewFile();
        }
    }

    public File getFile(String aProp, boolean[] aPersistent) {
        File file = null;
        if (aProp.equals("GreD") || aProp.equals("GreComsD")) {
            file = this.libXULPath;
            if (aProp.equals("GreComsD")) {
                file = new File(file, "components");
            }
        } else if (aProp.equals("MozBinD") || aProp.equals("CurProcD") || aProp.equals("ComsD")) {
            file = this.libXULPath;
            if (aProp.equals("ComsD")) {
                file = new File(file, "components");
            }
        } else {
            if (aProp.equals("ProfD") || aProp.equals("ProfDS") || aProp.equals("ProfLD") || aProp.equals("ProfLDS")) {
                return this.profile;
            }
            if (aProp.equals("UAppData")) {
                return this.profile;
            }
            if (aProp.equals("UMimTyp") && this.profile != null) {
                file = new File(this.profile, "mimeTypes.rdf");
            } else {
                if (aProp.equals("UHist")) {
                    return this.history;
                }
                if (aProp.equals("XCurProcD")) {
                    if (this.profile != null) {
                        return this.profile;
                    }
                    String userDir = System.getProperty("user.dir");
                    return new File(userDir);
                }
            }
        }
        return file;
    }

    public File[] getFiles(String aProp) {
        File[] files = null;
        if (aProp.equals("APluginsDL")) {
            if (Platform.platform == Platform.OSX) {
                log.debug("Adding global plugins for OSX");
                files = new File[]{new File(this.libXULPath, "plugins"), new File("/Library/Internet Plug-Ins")};
            } else {
                files = new File[]{new File(this.libXULPath, "plugins")};
            }
        }
        return files;
    }
}

